/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.net.bytebuddy.implementation.bind.annotation;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import io.trino.jdbc.$internal.net.bytebuddy.description.annotation.AnnotationDescription;
import io.trino.jdbc.$internal.net.bytebuddy.description.method.MethodDescription;
import io.trino.jdbc.$internal.net.bytebuddy.description.method.MethodList;
import io.trino.jdbc.$internal.net.bytebuddy.description.method.ParameterDescription;
import io.trino.jdbc.$internal.net.bytebuddy.description.type.TypeDescription;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.Implementation;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.MethodAccessorFactory;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.bind.MethodDelegationBinder;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.bytecode.StackManipulation;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.bytecode.assign.Assigner;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.bytecode.constant.MethodConstant;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.bytecode.constant.NullConstant;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.bytecode.member.FieldAccess;
import io.trino.jdbc.$internal.net.bytebuddy.jar.asm.MethodVisitor;
import io.trino.jdbc.$internal.net.bytebuddy.matcher.ElementMatchers;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface SuperMethod {
    public boolean cached() default true;

    public boolean privileged() default false;

    public boolean fallbackToDefault() default true;

    public boolean nullIfImpossible() default false;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Binder implements TargetMethodAnnotationDrivenBinder.ParameterBinder<SuperMethod>
    {
        INSTANCE;

        private static final MethodDescription.InDefinedShape CACHED;
        private static final MethodDescription.InDefinedShape PRIVILEGED;
        private static final MethodDescription.InDefinedShape FALLBACK_TO_DEFAULT;
        private static final MethodDescription.InDefinedShape NULL_IF_IMPOSSIBLE;

        @Override
        public Class<SuperMethod> getHandledType() {
            return SuperMethod.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<SuperMethod> annotation, MethodDescription source2, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner, Assigner.Typing typing) {
            if (!target.getType().asErasure().isAssignableFrom(Method.class)) {
                throw new IllegalStateException("Cannot assign Method type to " + target);
            }
            if (source2.isMethod()) {
                Implementation.SpecialMethodInvocation specialMethodInvocation = (annotation.getValue(FALLBACK_TO_DEFAULT).resolve(Boolean.class) != false ? implementationTarget.invokeDominant(source2.asSignatureToken()) : implementationTarget.invokeSuper(source2.asSignatureToken())).withCheckedCompatibilityTo(source2.asTypeToken());
                if (specialMethodInvocation.isValid()) {
                    return new MethodDelegationBinder.ParameterBinding.Anonymous(new DelegationMethod(specialMethodInvocation, annotation.getValue(CACHED).resolve(Boolean.class), annotation.getValue(PRIVILEGED).resolve(Boolean.class)));
                }
                if (annotation.getValue(NULL_IF_IMPOSSIBLE).resolve(Boolean.class).booleanValue()) {
                    return new MethodDelegationBinder.ParameterBinding.Anonymous(NullConstant.INSTANCE);
                }
                return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }
            if (annotation.getValue(NULL_IF_IMPOSSIBLE).resolve(Boolean.class).booleanValue()) {
                return new MethodDelegationBinder.ParameterBinding.Anonymous(NullConstant.INSTANCE);
            }
            return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
        }

        static {
            MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(SuperMethod.class).getDeclaredMethods();
            CACHED = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("cached"))).getOnly();
            PRIVILEGED = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("privileged"))).getOnly();
            FALLBACK_TO_DEFAULT = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("fallbackToDefault"))).getOnly();
            NULL_IF_IMPOSSIBLE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("nullIfImpossible"))).getOnly();
        }

        @HashCodeAndEqualsPlugin.Enhance
        protected static class DelegationMethod
        implements StackManipulation {
            private final Implementation.SpecialMethodInvocation specialMethodInvocation;
            private final boolean cached;
            private final boolean privileged;

            protected DelegationMethod(Implementation.SpecialMethodInvocation specialMethodInvocation, boolean cached, boolean privileged) {
                this.specialMethodInvocation = specialMethodInvocation;
                this.cached = cached;
                this.privileged = privileged;
            }

            public boolean isValid() {
                return this.specialMethodInvocation.isValid();
            }

            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                MethodConstant.CanCache methodConstant = this.privileged ? MethodConstant.ofPrivileged(implementationContext.registerAccessorFor(this.specialMethodInvocation, MethodAccessorFactory.AccessType.PUBLIC)) : MethodConstant.of(implementationContext.registerAccessorFor(this.specialMethodInvocation, MethodAccessorFactory.AccessType.PUBLIC));
                return (this.cached ? FieldAccess.forField(implementationContext.cache(methodConstant, TypeDescription.ForLoadedType.of(Method.class))).read() : methodConstant).apply(methodVisitor, implementationContext);
            }

            public boolean equals(@.MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (this.cached != ((DelegationMethod)object).cached) {
                    return false;
                }
                if (this.privileged != ((DelegationMethod)object).privileged) {
                    return false;
                }
                return this.specialMethodInvocation.equals(((DelegationMethod)object).specialMethodInvocation);
            }

            public int hashCode() {
                return ((this.getClass().hashCode() * 31 + this.specialMethodInvocation.hashCode()) * 31 + this.cached) * 31 + this.privileged;
            }
        }
    }
}

