/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.net.bytebuddy.implementation.attribute;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import io.trino.jdbc.$internal.net.bytebuddy.description.annotation.AnnotationDescription;
import io.trino.jdbc.$internal.net.bytebuddy.description.field.FieldDescription;
import io.trino.jdbc.$internal.net.bytebuddy.description.type.TypeDescription;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.attribute.AnnotationAppender;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.attribute.AnnotationValueFilter;
import io.trino.jdbc.$internal.net.bytebuddy.jar.asm.FieldVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public interface FieldAttributeAppender {
    public void apply(FieldVisitor var1, FieldDescription var2, AnnotationValueFilter var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Compound
    implements FieldAttributeAppender {
        private final List<FieldAttributeAppender> fieldAttributeAppenders = new ArrayList<FieldAttributeAppender>();

        public Compound(FieldAttributeAppender ... fieldAttributeAppender) {
            this(Arrays.asList(fieldAttributeAppender));
        }

        public Compound(List<? extends FieldAttributeAppender> fieldAttributeAppenders) {
            for (FieldAttributeAppender fieldAttributeAppender : fieldAttributeAppenders) {
                if (fieldAttributeAppender instanceof Compound) {
                    this.fieldAttributeAppenders.addAll(((Compound)fieldAttributeAppender).fieldAttributeAppenders);
                    continue;
                }
                if (fieldAttributeAppender instanceof NoOp) continue;
                this.fieldAttributeAppenders.add(fieldAttributeAppender);
            }
        }

        @Override
        public void apply(FieldVisitor fieldVisitor, FieldDescription fieldDescription, AnnotationValueFilter annotationValueFilter) {
            for (FieldAttributeAppender fieldAttributeAppender : this.fieldAttributeAppenders) {
                fieldAttributeAppender.apply(fieldVisitor, fieldDescription, annotationValueFilter);
            }
        }

        public boolean equals(@.MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return ((Object)this.fieldAttributeAppenders).equals(((Compound)object).fieldAttributeAppenders);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + ((Object)this.fieldAttributeAppenders).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Explicit
    implements FieldAttributeAppender,
    Factory {
        private final List<? extends AnnotationDescription> annotations;

        public Explicit(List<? extends AnnotationDescription> annotations) {
            this.annotations = annotations;
        }

        @Override
        public void apply(FieldVisitor fieldVisitor, FieldDescription fieldDescription, AnnotationValueFilter annotationValueFilter) {
            AnnotationAppender appender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnField(fieldVisitor));
            for (AnnotationDescription annotationDescription : this.annotations) {
                appender = appender.append(annotationDescription, annotationValueFilter);
            }
        }

        @Override
        public FieldAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        public boolean equals(@.MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return ((Object)this.annotations).equals(((Explicit)object).annotations);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + ((Object)this.annotations).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ForInstrumentedField implements FieldAttributeAppender,
    Factory
    {
        INSTANCE;


        @Override
        public void apply(FieldVisitor fieldVisitor, FieldDescription fieldDescription, AnnotationValueFilter annotationValueFilter) {
            AnnotationAppender annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnField(fieldVisitor));
            annotationAppender = fieldDescription.getType().accept(AnnotationAppender.ForTypeAnnotations.ofFieldType(annotationAppender, annotationValueFilter));
            for (AnnotationDescription annotation : fieldDescription.getDeclaredAnnotations()) {
                annotationAppender = annotationAppender.append(annotation, annotationValueFilter);
            }
        }

        @Override
        public FieldAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }
    }

    public static interface Factory {
        public FieldAttributeAppender make(TypeDescription var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class Compound
        implements Factory {
            private final List<Factory> factories = new ArrayList<Factory>();

            public Compound(Factory ... factory2) {
                this(Arrays.asList(factory2));
            }

            public Compound(List<? extends Factory> factories) {
                for (Factory factory2 : factories) {
                    if (factory2 instanceof Compound) {
                        this.factories.addAll(((Compound)factory2).factories);
                        continue;
                    }
                    if (factory2 instanceof NoOp) continue;
                    this.factories.add(factory2);
                }
            }

            @Override
            public FieldAttributeAppender make(TypeDescription typeDescription) {
                ArrayList<FieldAttributeAppender> fieldAttributeAppenders = new ArrayList<FieldAttributeAppender>(this.factories.size());
                for (Factory factory2 : this.factories) {
                    fieldAttributeAppenders.add(factory2.make(typeDescription));
                }
                return new io.trino.jdbc.$internal.net.bytebuddy.implementation.attribute.FieldAttributeAppender$Compound(fieldAttributeAppenders);
            }

            public boolean equals(@.MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return ((Object)this.factories).equals(((Compound)object).factories);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + ((Object)this.factories).hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NoOp implements FieldAttributeAppender,
    Factory
    {
        INSTANCE;


        @Override
        public FieldAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public void apply(FieldVisitor fieldVisitor, FieldDescription fieldDescription, AnnotationValueFilter annotationValueFilter) {
        }
    }
}

