/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.common;

import io.trino.hive.$internal.com.google.common.base.Optional;
import io.trino.hive.$internal.com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public enum HCatContext {
    INSTANCE;

    private Configuration conf = null;

    public synchronized HCatContext setConf(Configuration newConf) {
        Preconditions.checkNotNull(newConf, "Required parameter 'newConf' must not be null.");
        if (this.conf == null) {
            this.conf = newConf;
            return this;
        }
        for (Map.Entry entry : this.conf) {
            if (!((String)entry.getKey()).matches("hcat.*") || newConf.get((String)entry.getKey()) != null) continue;
            newConf.set((String)entry.getKey(), (String)entry.getValue());
        }
        this.conf = newConf;
        return this;
    }

    public Optional<Configuration> getConf() {
        return Optional.fromNullable(this.conf);
    }
}

