/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.StatsTask;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.TaskGraphWalker;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MergeJoinWork;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;

public class SerializeFilter
implements PhysicalPlanResolver {
    protected static final transient Logger LOG = LoggerFactory.getLogger(SerializeFilter.class);

    @Override
    public PhysicalContext resolve(PhysicalContext pctx) throws SemanticException {
        pctx.getConf();
        Serializer disp = new Serializer(pctx);
        TaskGraphWalker ogw = new TaskGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getRootTasks());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    public class Serializer
    implements Dispatcher {
        private final PhysicalContext pctx;

        public Serializer(PhysicalContext pctx) {
            this.pctx = pctx;
        }

        @Override
        public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
            Task currTask = (Task)nd;
            if (currTask instanceof StatsTask) {
                currTask = ((StatsWork)((StatsTask)currTask).getWork()).getSourceTask();
            }
            if (currTask instanceof TezTask) {
                TezWork work = (TezWork)((TezTask)currTask).getWork();
                for (BaseWork w : work.getAllWork()) {
                    this.evaluateWork(w);
                }
            }
            return null;
        }

        private void evaluateWork(BaseWork w) throws SemanticException {
            if (w instanceof MapWork) {
                this.evaluateMapWork((MapWork)w);
            } else if (w instanceof ReduceWork) {
                this.evaluateReduceWork((ReduceWork)w);
            } else if (w instanceof MergeJoinWork) {
                this.evaluateMergeWork((MergeJoinWork)w);
            } else {
                LOG.info("We are not going to evaluate this work type: " + w.getClass().getCanonicalName());
            }
        }

        private void evaluateMergeWork(MergeJoinWork w) throws SemanticException {
            for (BaseWork baseWork : w.getBaseWorkList()) {
                this.evaluateOperators(baseWork, this.pctx);
            }
        }

        private void evaluateReduceWork(ReduceWork w) throws SemanticException {
            this.evaluateOperators(w, this.pctx);
        }

        private void evaluateMapWork(MapWork w) throws SemanticException {
            this.evaluateOperators(w, this.pctx);
        }

        private void evaluateOperators(BaseWork w, PhysicalContext pctx) throws SemanticException {
            DefaultRuleDispatcher disp = null;
            final LinkedHashSet tableScans = new LinkedHashSet();
            LinkedHashMap<Rule, NodeProcessor> rules = new LinkedHashMap<Rule, NodeProcessor>();
            rules.put(new RuleRegExp("TS finder", TableScanOperator.getOperatorName() + "%"), new NodeProcessor(){

                @Override
                public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) {
                    tableScans.add((TableScanOperator)nd);
                    return null;
                }
            });
            disp = new DefaultRuleDispatcher(null, rules, null);
            DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.addAll(w.getAllRootOperators());
            LinkedHashMap<Node, Object> nodeOutput = new LinkedHashMap<Node, Object>();
            ogw.startWalking(topNodes, nodeOutput);
            for (TableScanOperator ts : tableScans) {
                if (ts.getConf() != null && ((TableScanDesc)ts.getConf()).getFilterExpr() != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Serializing: " + ((TableScanDesc)ts.getConf()).getFilterExpr().getExprString());
                    }
                    ((TableScanDesc)ts.getConf()).setSerializedFilterExpr(SerializationUtilities.serializeExpression(((TableScanDesc)ts.getConf()).getFilterExpr()));
                }
                if (ts.getConf() == null || ((TableScanDesc)ts.getConf()).getFilterObject() == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Serializing: " + ((TableScanDesc)ts.getConf()).getFilterObject());
                }
                ((TableScanDesc)ts.getConf()).setSerializedFilterObject(SerializationUtilities.serializeObject(((TableScanDesc)ts.getConf()).getFilterObject()));
            }
        }

        public class DefaultRule
        implements NodeProcessor {
            @Override
            public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
                return null;
            }
        }
    }
}

