/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.correlation;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.correlation.AbstractCorrelationProcCtx;
import org.apache.hadoop.hive.ql.optimizer.correlation.CorrelationUtilities;
import org.apache.hadoop.hive.ql.optimizer.correlation.ReduceSinkDeDuplicationUtils;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;

public class ReduceSinkDeDuplication
extends Transform {
    protected static final Logger LOG = LoggerFactory.getLogger(ReduceSinkDeDuplication.class);
    private static final String RS = ReduceSinkOperator.getOperatorName();
    private static final String GBY = GroupByOperator.getOperatorName();
    private static final String JOIN = JoinOperator.getOperatorName();
    protected ParseContext pGraphContext;

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        this.pGraphContext = pctx;
        ReduceSinkDeduplicateProcCtx cppCtx = new ReduceSinkDeduplicateProcCtx(this.pGraphContext);
        boolean mergeJoins = !pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVECONVERTJOIN) && !pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASK) && !pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_CONVERT_JOIN_BUCKET_MAPJOIN_TEZ) && !pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVEDYNAMICPARTITIONHASHJOIN);
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", RS + "%.*%" + RS + "%"), ReduceSinkDeduplicateProcFactory.getReducerReducerProc());
        opRules.put(new RuleRegExp("R2", RS + "%" + GBY + "%.*%" + RS + "%"), ReduceSinkDeduplicateProcFactory.getGroupbyReducerProc());
        if (mergeJoins) {
            opRules.put(new RuleRegExp("R3", JOIN + "%.*%" + RS + "%"), ReduceSinkDeduplicateProcFactory.getJoinReducerProc());
        }
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(ReduceSinkDeduplicateProcFactory.getDefaultProc(), opRules, cppCtx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(this.pGraphContext.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return this.pGraphContext;
    }

    static class ReducerReducerProc
    extends AbsctractReducerReducerProc {
        ReducerReducerProc() {
        }

        @Override
        public Object process(ReduceSinkOperator cRS, ReduceSinkDeduplicateProcCtx dedupCtx) throws SemanticException {
            ReduceSinkOperator pRS = CorrelationUtilities.findPossibleParent(cRS, ReduceSinkOperator.class, dedupCtx.trustScript());
            if (pRS != null) {
                if (ReduceSinkDeDuplicationUtils.aggressiveDedup(cRS, pRS, dedupCtx)) {
                    return true;
                }
                if (ReduceSinkDeDuplicationUtils.merge(cRS, pRS, dedupCtx.minReducer())) {
                    CorrelationUtilities.replaceReduceSinkWithSelectOperator(cRS, dedupCtx.getPctx(), dedupCtx);
                    ((ReduceSinkDesc)pRS.getConf()).setDeduplicated(true);
                    return true;
                }
            }
            return false;
        }

        @Override
        public Object process(ReduceSinkOperator cRS, GroupByOperator cGBY, ReduceSinkDeduplicateProcCtx dedupCtx) throws SemanticException {
            Operator<?> start = CorrelationUtilities.getStartForGroupBy(cRS, dedupCtx);
            ReduceSinkOperator pRS = CorrelationUtilities.findPossibleParent(start, ReduceSinkOperator.class, dedupCtx.trustScript());
            if (pRS != null && ReduceSinkDeDuplicationUtils.merge(cRS, pRS, dedupCtx.minReducer())) {
                if (dedupCtx.getPctx().getConf().getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW)) {
                    return false;
                }
                CorrelationUtilities.removeReduceSinkForGroupBy(cRS, cGBY, dedupCtx.getPctx(), dedupCtx);
                ((ReduceSinkDesc)pRS.getConf()).setDeduplicated(true);
                return true;
            }
            return false;
        }
    }

    static class JoinReducerProc
    extends AbsctractReducerReducerProc {
        JoinReducerProc() {
        }

        @Override
        public Object process(ReduceSinkOperator cRS, ReduceSinkDeduplicateProcCtx dedupCtx) throws SemanticException {
            JoinOperator pJoin = CorrelationUtilities.findPossibleParent(cRS, JoinOperator.class, dedupCtx.trustScript());
            if (pJoin != null && ReduceSinkDeDuplicationUtils.merge(cRS, pJoin, dedupCtx.minReducer())) {
                ((JoinDesc)pJoin.getConf()).setFixedAsSorted(true);
                CorrelationUtilities.replaceReduceSinkWithSelectOperator(cRS, dedupCtx.getPctx(), dedupCtx);
                ReduceSinkOperator pRS = CorrelationUtilities.findPossibleParent(pJoin, ReduceSinkOperator.class, dedupCtx.trustScript());
                if (pRS != null) {
                    ((ReduceSinkDesc)pRS.getConf()).setDeduplicated(true);
                }
                return true;
            }
            return false;
        }

        @Override
        public Object process(ReduceSinkOperator cRS, GroupByOperator cGBY, ReduceSinkDeduplicateProcCtx dedupCtx) throws SemanticException {
            Operator<?> start = CorrelationUtilities.getStartForGroupBy(cRS, dedupCtx);
            JoinOperator pJoin = CorrelationUtilities.findPossibleParent(start, JoinOperator.class, dedupCtx.trustScript());
            if (pJoin != null && ReduceSinkDeDuplicationUtils.merge(cRS, pJoin, dedupCtx.minReducer())) {
                ((JoinDesc)pJoin.getConf()).setFixedAsSorted(true);
                CorrelationUtilities.removeReduceSinkForGroupBy(cRS, cGBY, dedupCtx.getPctx(), dedupCtx);
                ReduceSinkOperator pRS = CorrelationUtilities.findPossibleParent(pJoin, ReduceSinkOperator.class, dedupCtx.trustScript());
                if (pRS != null) {
                    ((ReduceSinkDesc)pRS.getConf()).setDeduplicated(true);
                }
                return true;
            }
            return false;
        }
    }

    static class GroupbyReducerProc
    extends AbsctractReducerReducerProc {
        GroupbyReducerProc() {
        }

        @Override
        public Object process(ReduceSinkOperator cRS, ReduceSinkDeduplicateProcCtx dedupCtx) throws SemanticException {
            GroupByOperator pGBY = CorrelationUtilities.findPossibleParent(cRS, GroupByOperator.class, dedupCtx.trustScript());
            if (pGBY == null) {
                return false;
            }
            ReduceSinkOperator pRS = CorrelationUtilities.findPossibleParent(pGBY, ReduceSinkOperator.class, dedupCtx.trustScript());
            if (pRS != null && ReduceSinkDeDuplicationUtils.merge(cRS, pRS, dedupCtx.minReducer())) {
                CorrelationUtilities.replaceReduceSinkWithSelectOperator(cRS, dedupCtx.getPctx(), dedupCtx);
                ((ReduceSinkDesc)pRS.getConf()).setDeduplicated(true);
                return true;
            }
            return false;
        }

        @Override
        public Object process(ReduceSinkOperator cRS, GroupByOperator cGBY, ReduceSinkDeduplicateProcCtx dedupCtx) throws SemanticException {
            Operator<?> start = CorrelationUtilities.getStartForGroupBy(cRS, dedupCtx);
            GroupByOperator pGBY = CorrelationUtilities.findPossibleParent(start, GroupByOperator.class, dedupCtx.trustScript());
            if (pGBY == null) {
                return false;
            }
            ReduceSinkOperator pRS = CorrelationUtilities.getSingleParent(pGBY, ReduceSinkOperator.class);
            if (pRS != null && ReduceSinkDeDuplicationUtils.merge(cRS, pRS, dedupCtx.minReducer())) {
                CorrelationUtilities.removeReduceSinkForGroupBy(cRS, cGBY, dedupCtx.getPctx(), dedupCtx);
                ((ReduceSinkDesc)pRS.getConf()).setDeduplicated(true);
                return true;
            }
            return false;
        }
    }

    public static abstract class AbsctractReducerReducerProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ReduceSinkDeduplicateProcCtx dedupCtx = (ReduceSinkDeduplicateProcCtx)procCtx;
            if (dedupCtx.hasBeenRemoved((Operator)nd)) {
                return false;
            }
            ReduceSinkOperator cRS = (ReduceSinkOperator)nd;
            Operator<?> child = CorrelationUtilities.getSingleChild(cRS);
            if (child instanceof JoinOperator) {
                return false;
            }
            if (child instanceof GroupByOperator) {
                GroupByOperator cGBY = (GroupByOperator)child;
                if (!CorrelationUtilities.hasGroupingSet(cRS) && !((GroupByDesc)cGBY.getConf()).isGroupingSetsPresent()) {
                    return this.process(cRS, cGBY, dedupCtx);
                }
                return false;
            }
            if (child instanceof SelectOperator) {
                return this.process(cRS, dedupCtx);
            }
            return false;
        }

        protected abstract Object process(ReduceSinkOperator var1, ReduceSinkDeduplicateProcCtx var2) throws SemanticException;

        protected abstract Object process(ReduceSinkOperator var1, GroupByOperator var2, ReduceSinkDeduplicateProcCtx var3) throws SemanticException;
    }

    static class DefaultProc
    implements NodeProcessor {
        DefaultProc() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            return null;
        }
    }

    static class ReduceSinkDeduplicateProcFactory {
        ReduceSinkDeduplicateProcFactory() {
        }

        public static NodeProcessor getReducerReducerProc() {
            return new ReducerReducerProc();
        }

        public static NodeProcessor getGroupbyReducerProc() {
            return new GroupbyReducerProc();
        }

        public static NodeProcessor getJoinReducerProc() {
            return new JoinReducerProc();
        }

        public static NodeProcessor getDefaultProc() {
            return new DefaultProc();
        }
    }

    protected class ReduceSinkDeduplicateProcCtx
    extends AbstractCorrelationProcCtx {
        public ReduceSinkDeduplicateProcCtx(ParseContext pctx) {
            super(pctx);
        }
    }
}

