/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.math.BigDecimal;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.HiveJdbcConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.JdbcHiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;

public class ASTBuilder {
    public static final Logger LOGGER = LoggerFactory.getLogger(ASTBuilder.class);
    ASTNode curr;

    public static ASTBuilder construct(int tokenType, String text) {
        ASTBuilder b = new ASTBuilder();
        b.curr = ASTBuilder.createAST(tokenType, text);
        return b;
    }

    public static ASTNode createAST(int tokenType, String text) {
        return (ASTNode)ParseDriver.adaptor.create(tokenType, text);
    }

    public static ASTNode destNode() {
        return ASTBuilder.construct(810, "TOK_DESTINATION").add(ASTBuilder.construct(812, "TOK_DIR").add(1073, "TOK_TMP_FILE")).node();
    }

    public static ASTNode table(RelNode scan) {
        HiveTableScan hts = null;
        if (scan instanceof HiveJdbcConverter) {
            HiveJdbcConverter jdbcConverter = (HiveJdbcConverter)scan;
            JdbcHiveTableScan jdbcHiveTableScan = jdbcConverter.getTableScan();
            hts = jdbcHiveTableScan.getHiveTableScan();
        } else {
            hts = scan instanceof DruidQuery ? (HiveTableScan)((DruidQuery)scan).getTableScan() : (HiveTableScan)scan;
        }
        assert (hts != null);
        RelOptHiveTable hTbl = (RelOptHiveTable)hts.getTable();
        ASTBuilder b = ASTBuilder.construct(1062, "TOK_TABREF").add(ASTBuilder.construct(1061, "TOK_TABNAME").add(24, hTbl.getHiveTableMD().getDbName()).add(24, hTbl.getHiveTableMD().getTableName()));
        ASTBuilder propList = ASTBuilder.construct(1048, "TOK_TABLEPROPLIST");
        if (scan instanceof DruidQuery) {
            DruidQuery dq = (DruidQuery)scan;
            propList.add(ASTBuilder.construct(1047, "TOK_TABLEPROPERTY").add(379, "\"druid.query.json\"").add(379, "\"" + SemanticAnalyzer.escapeSQLString(dq.getQueryString()) + "\""));
            propList.add(ASTBuilder.construct(1047, "TOK_TABLEPROPERTY").add(379, "\"druid.fieldNames\"").add(379, "\"" + dq.getRowType().getFieldNames().stream().map(Object::toString).collect(Collectors.joining(",")) + "\""));
            propList.add(ASTBuilder.construct(1047, "TOK_TABLEPROPERTY").add(379, "\"druid.fieldTypes\"").add(379, "\"" + dq.getRowType().getFieldList().stream().map(e -> TypeConverter.convert(e.getType()).getTypeName()).collect(Collectors.joining(",")) + "\""));
            propList.add(ASTBuilder.construct(1047, "TOK_TABLEPROPERTY").add(379, "\"druid.query.type\"").add(379, "\"" + dq.getQueryType().getQueryName() + "\""));
        } else if (scan instanceof HiveJdbcConverter) {
            HiveJdbcConverter jdbcConverter = (HiveJdbcConverter)scan;
            String query = jdbcConverter.generateSql();
            LOGGER.info("The HiveJdbcConverter generated sql message is: " + System.lineSeparator() + query);
            propList.add(ASTBuilder.construct(1047, "TOK_TABLEPROPERTY").add(379, "\"hive.sql.query\"").add(379, "\"" + SemanticAnalyzer.escapeSQLString(query) + "\""));
            propList.add(ASTBuilder.construct(1047, "TOK_TABLEPROPERTY").add(379, "\"hive.sql.generated.query\"").add(379, "\"" + SemanticAnalyzer.escapeSQLString(query) + "\""));
        }
        if (hts.isInsideView()) {
            propList.add(ASTBuilder.construct(1047, "TOK_TABLEPROPERTY").add(379, "\"insideView\"").add(379, "\"TRUE\""));
        }
        b.add(ASTBuilder.construct(1046, "TOK_TABLEPROPERTIES").add(propList));
        b.add(24, hts.getTableAlias());
        return b.node();
    }

    public static ASTNode join(ASTNode left, ASTNode right, JoinRelType joinType, ASTNode cond, boolean semiJoin) {
        ASTBuilder b = null;
        switch (joinType) {
            case INNER: {
                if (semiJoin) {
                    b = ASTBuilder.construct(882, "TOK_LEFTSEMIJOIN");
                    break;
                }
                b = ASTBuilder.construct(877, "TOK_JOIN");
                break;
            }
            case LEFT: {
                b = ASTBuilder.construct(881, "TOK_LEFTOUTERJOIN");
                break;
            }
            case RIGHT: {
                b = ASTBuilder.construct(977, "TOK_RIGHTOUTERJOIN");
                break;
            }
            case FULL: {
                b = ASTBuilder.construct(841, "TOK_FULLOUTERJOIN");
            }
        }
        b.add(left).add(right).add(cond);
        return b.node();
    }

    public static ASTNode subQuery(ASTNode qry, String alias) {
        return ASTBuilder.construct(1026, "TOK_SUBQUERY").add(qry).add(24, alias).node();
    }

    public static ASTNode qualifiedName(String tableName, String colName) {
        ASTBuilder b = ASTBuilder.construct(16, ".").add(ASTBuilder.construct(1058, "TOK_TABLE_OR_COL").add(24, tableName)).add(24, colName);
        return b.node();
    }

    public static ASTNode unqualifiedName(String colName) {
        ASTBuilder b = ASTBuilder.construct(1058, "TOK_TABLE_OR_COL").add(24, colName);
        return b.node();
    }

    public static ASTNode where(ASTNode cond) {
        return ASTBuilder.construct(1099, "TOK_WHERE").add(cond).node();
    }

    public static ASTNode having(ASTNode cond) {
        return ASTBuilder.construct(854, "TOK_HAVING").add(cond).node();
    }

    public static ASTNode limit(Object offset, Object limit) {
        return ASTBuilder.construct(886, "TOK_LIMIT").add(367, offset.toString()).add(367, limit.toString()).node();
    }

    public static ASTNode selectExpr(ASTNode expr, String alias) {
        return ASTBuilder.construct(985, "TOK_SELEXPR").add(expr).add(24, alias).node();
    }

    public static ASTNode literal(RexLiteral literal) {
        return ASTBuilder.literal(literal, false);
    }

    public static ASTNode literal(RexLiteral literal, boolean useTypeQualInLiteral) {
        Object val = null;
        int type = 0;
        SqlTypeName sqlType = literal.getType().getSqlTypeName();
        switch (sqlType) {
            case BINARY: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_MONTH: 
            case INTERVAL_SECOND: 
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: {
                if (literal.getValue() != null) break;
                return ASTBuilder.construct(903, "TOK_NULL").node();
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DOUBLE: 
            case DECIMAL: 
            case FLOAT: 
            case REAL: 
            case VARCHAR: 
            case CHAR: 
            case BOOLEAN: {
                if (literal.getValue3() != null) break;
                return ASTBuilder.construct(903, "TOK_NULL").node();
            }
        }
        switch (sqlType) {
            case TINYINT: {
                val = useTypeQualInLiteral ? literal.getValue3() + "Y" : literal.getValue3();
                type = 25;
                break;
            }
            case SMALLINT: {
                val = useTypeQualInLiteral ? literal.getValue3() + "S" : literal.getValue3();
                type = 25;
                break;
            }
            case INTEGER: {
                val = literal.getValue3();
                type = 25;
                break;
            }
            case BIGINT: {
                val = useTypeQualInLiteral ? literal.getValue3() + "L" : literal.getValue3();
                type = 25;
                break;
            }
            case DOUBLE: {
                val = literal.getValue3() + "D";
                type = 368;
                break;
            }
            case DECIMAL: {
                val = literal.getValue3() + "BD";
                type = 368;
                break;
            }
            case FLOAT: 
            case REAL: {
                val = literal.getValue3();
                type = 367;
                break;
            }
            case VARCHAR: 
            case CHAR: {
                val = literal.getValue3();
                String escapedVal = BaseSemanticAnalyzer.escapeSQLString(String.valueOf(val));
                type = 379;
                val = "'" + escapedVal + "'";
                break;
            }
            case BOOLEAN: {
                val = literal.getValue3();
                type = (Boolean)val != false ? 318 : 126;
                break;
            }
            case DATE: {
                val = "'" + ((DateString)literal.getValueAs(DateString.class)).toString() + "'";
                type = 797;
                break;
            }
            case TIME: {
                val = "'" + ((TimeString)literal.getValueAs(TimeString.class)).toString() + "'";
                type = 1069;
                break;
            }
            case TIMESTAMP: {
                val = "'" + ((TimestampString)literal.getValueAs(TimestampString.class)).toString() + "'";
                type = 1069;
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                val = "'" + ((TimestampString)literal.getValueAs(TimestampString.class)).toString() + " UTC'";
                type = 1071;
                break;
            }
            case INTERVAL_MONTH: 
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: {
                type = 873;
                BigDecimal monthsBd = (BigDecimal)literal.getValue();
                HiveIntervalYearMonth intervalYearMonth = new HiveIntervalYearMonth(monthsBd.intValue());
                val = "'" + intervalYearMonth.toString() + "'";
                break;
            }
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                type = 866;
                BigDecimal millisBd = (BigDecimal)literal.getValue();
                BigDecimal secsBd = millisBd.divide(BigDecimal.valueOf(1000L));
                HiveIntervalDayTime intervalDayTime = new HiveIntervalDayTime(secsBd);
                val = "'" + intervalDayTime.toString() + "'";
                break;
            }
            case NULL: {
                type = 903;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported Type: " + sqlType);
            }
        }
        return (ASTNode)ParseDriver.adaptor.create(type, String.valueOf(val));
    }

    public ASTNode node() {
        return this.curr;
    }

    public ASTBuilder add(int tokenType, String text) {
        ParseDriver.adaptor.addChild((Object)this.curr, (Object)ASTBuilder.createAST(tokenType, text));
        return this;
    }

    public ASTBuilder add(ASTBuilder b) {
        ParseDriver.adaptor.addChild((Object)this.curr, (Object)b.curr);
        return this;
    }

    public ASTBuilder add(ASTNode n) {
        if (n != null) {
            ParseDriver.adaptor.addChild((Object)this.curr, (Object)n);
        }
        return this;
    }
}

