/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.cost;

import io.trino.hive.$internal.com.google.common.collect.ImmutableList;
import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.util.Set;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;

public abstract class HiveCostModel {
    private static final Logger LOG = LoggerFactory.getLogger(HiveCostModel.class);
    private final Set<JoinAlgorithm> joinAlgorithms;

    public HiveCostModel(Set<JoinAlgorithm> joinAlgorithms) {
        this.joinAlgorithms = joinAlgorithms;
    }

    public abstract RelOptCost getDefaultCost();

    public abstract RelOptCost getAggregateCost(HiveAggregate var1);

    public abstract RelOptCost getScanCost(HiveTableScan var1, RelMetadataQuery var2);

    public RelOptCost getJoinCost(HiveJoin join) {
        JoinAlgorithm joinAlgorithm = null;
        RelOptCost minJoinCost = null;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Join algorithm selection for:\n" + RelOptUtil.toString((RelNode)join));
        }
        for (JoinAlgorithm possibleAlgorithm : this.joinAlgorithms) {
            if (!possibleAlgorithm.isExecutable(join)) continue;
            RelOptCost joinCost = possibleAlgorithm.getCost(join);
            if (LOG.isTraceEnabled()) {
                LOG.trace(possibleAlgorithm + " cost: " + joinCost);
            }
            if (minJoinCost != null && !joinCost.isLt(minJoinCost)) continue;
            joinAlgorithm = possibleAlgorithm;
            minJoinCost = joinCost;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(joinAlgorithm + " selected");
        }
        join.setJoinAlgorithm(joinAlgorithm);
        join.setJoinCost(minJoinCost);
        return minJoinCost;
    }

    public static interface JoinAlgorithm {
        public String toString();

        public boolean isExecutable(HiveJoin var1);

        public RelOptCost getCost(HiveJoin var1);

        public ImmutableList<RelCollation> getCollation(HiveJoin var1);

        public RelDistribution getDistribution(HiveJoin var1);

        public Double getMemory(HiveJoin var1);

        public Double getCumulativeMemoryWithinPhaseSplit(HiveJoin var1);

        public Boolean isPhaseTransition(HiveJoin var1);

        public Integer getSplitCount(HiveJoin var1);
    }
}

