/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.read;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.StatsProvidingRecordReader;
import org.apache.hadoop.hive.ql.io.parquet.ParquetRecordReaderBase;
import org.apache.hadoop.hive.ql.io.parquet.ProjectionPusher;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.util.ContextUtil;

public class ParquetRecordReaderWrapper
extends ParquetRecordReaderBase
implements org.apache.hadoop.mapred.RecordReader<NullWritable, ArrayWritable>,
StatsProvidingRecordReader {
    public static final Logger LOG = LoggerFactory.getLogger(ParquetRecordReaderWrapper.class);
    private final long splitLen;
    private RecordReader<Void, ArrayWritable> realReader;
    private ArrayWritable valueObj = null;
    private boolean firstRecord = false;
    private boolean eof = false;

    public ParquetRecordReaderWrapper(ParquetInputFormat<ArrayWritable> newInputFormat, org.apache.hadoop.mapred.InputSplit oldSplit, JobConf oldJobConf, Reporter reporter) throws IOException, InterruptedException {
        this(newInputFormat, oldSplit, oldJobConf, reporter, new ProjectionPusher());
    }

    public ParquetRecordReaderWrapper(ParquetInputFormat<ArrayWritable> newInputFormat, org.apache.hadoop.mapred.InputSplit oldSplit, JobConf oldJobConf, Reporter reporter, ProjectionPusher pusher) throws IOException, InterruptedException {
        JobConf conf;
        this.splitLen = oldSplit.getLength();
        this.projectionPusher = pusher;
        this.serDeStats = new SerDeStats();
        this.jobConf = oldJobConf;
        ParquetInputSplit split = this.getSplit(oldSplit, this.jobConf);
        TaskAttemptID taskAttemptID = TaskAttemptID.forName((String)this.jobConf.get("mapred.task.id"));
        if (taskAttemptID == null) {
            taskAttemptID = new TaskAttemptID();
        }
        if (this.skipTimestampConversion ^ HiveConf.getBoolVar((Configuration)(conf = this.jobConf), HiveConf.ConfVars.HIVE_PARQUET_TIMESTAMP_SKIP_CONVERSION)) {
            conf = new JobConf((Configuration)oldJobConf);
            HiveConf.setBoolVar((Configuration)conf, HiveConf.ConfVars.HIVE_PARQUET_TIMESTAMP_SKIP_CONVERSION, this.skipTimestampConversion);
        }
        TaskAttemptContext taskContext = ContextUtil.newTaskAttemptContext((Configuration)conf, (TaskAttemptID)taskAttemptID);
        if (split != null) {
            try {
                this.realReader = newInputFormat.createRecordReader((InputSplit)split, taskContext);
                this.realReader.initialize((InputSplit)split, taskContext);
                if (this.realReader.nextKeyValue()) {
                    this.firstRecord = true;
                    this.valueObj = (ArrayWritable)this.realReader.getCurrentValue();
                }
                this.eof = true;
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        } else {
            this.realReader = null;
            this.eof = true;
        }
        if (this.valueObj == null) {
            this.valueObj = new ArrayWritable(Writable.class, new Writable[this.schemaSize]);
        }
    }

    public void close() throws IOException {
        if (this.realReader != null) {
            this.realReader.close();
        }
    }

    public NullWritable createKey() {
        return null;
    }

    public ArrayWritable createValue() {
        return this.valueObj;
    }

    public long getPos() throws IOException {
        return (long)((float)this.splitLen * this.getProgress());
    }

    public float getProgress() throws IOException {
        if (this.realReader == null) {
            return 1.0f;
        }
        try {
            return this.realReader.getProgress();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public boolean next(NullWritable key, ArrayWritable value) throws IOException {
        if (this.eof) {
            return false;
        }
        try {
            if (this.firstRecord) {
                this.firstRecord = false;
            } else if (!this.realReader.nextKeyValue()) {
                this.eof = true;
                return false;
            }
            ArrayWritable tmpCurValue = (ArrayWritable)this.realReader.getCurrentValue();
            if (value != tmpCurValue) {
                Writable[] arrValue = value.get();
                Writable[] arrCurrent = tmpCurValue.get();
                if (value != null && arrValue.length == arrCurrent.length) {
                    System.arraycopy(arrCurrent, 0, arrValue, 0, arrCurrent.length);
                } else {
                    if (arrValue.length != arrCurrent.length) {
                        throw new IOException("DeprecatedParquetHiveInput : size of object differs. Value size :  " + arrValue.length + ", Current Object size : " + arrCurrent.length);
                    }
                    throw new IOException("DeprecatedParquetHiveInput can not support RecordReaders that don't return same key & value & value is null");
                }
            }
            return true;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

