/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import io.trino.hive.$internal.com.google.common.base.Strings;
import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.parquet.ProjectionPusher;
import org.apache.hadoop.hive.ql.io.parquet.read.DataWritableReadSupport;
import org.apache.hadoop.hive.ql.io.parquet.read.ParquetFilterPredicateConverter;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.compat.RowGroupFilter;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;

public class ParquetRecordReaderBase {
    public static final Logger LOG = LoggerFactory.getLogger(ParquetRecordReaderBase.class);
    protected Path file;
    protected ProjectionPusher projectionPusher;
    protected boolean skipTimestampConversion = false;
    protected SerDeStats serDeStats;
    protected JobConf jobConf;
    protected int schemaSize;
    protected List<BlockMetaData> filtedBlocks;
    protected ParquetFileReader reader;

    protected ParquetInputSplit getSplit(InputSplit oldSplit, JobConf conf) throws IOException {
        if (oldSplit instanceof FileSplit) {
            Path finalPath = ((FileSplit)oldSplit).getPath();
            this.jobConf = this.projectionPusher.pushProjectionsAndFilters(conf, finalPath.getParent());
            ParquetMetadata parquetMetadata = ParquetFileReader.readFooter((Configuration)this.jobConf, (Path)finalPath);
            List blocks = parquetMetadata.getBlocks();
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            ReadSupport.ReadContext readContext = new DataWritableReadSupport().init(new InitContext((Configuration)this.jobConf, null, fileMetaData.getSchema()));
            for (BlockMetaData bmd : blocks) {
                this.serDeStats.setRowCount(this.serDeStats.getRowCount() + bmd.getRowCount());
                this.serDeStats.setRawDataSize(this.serDeStats.getRawDataSize() + bmd.getTotalByteSize());
            }
            this.schemaSize = MessageTypeParser.parseMessageType((String)((String)readContext.getReadSupportMetadata().get("HIVE_TABLE_SCHEMA"))).getFieldCount();
            ArrayList<BlockMetaData> splitGroup = new ArrayList<BlockMetaData>();
            long splitStart = ((FileSplit)oldSplit).getStart();
            long splitLength = ((FileSplit)oldSplit).getLength();
            for (BlockMetaData block : blocks) {
                long firstDataPage = ((ColumnChunkMetaData)block.getColumns().get(0)).getFirstDataPageOffset();
                if (firstDataPage < splitStart || firstDataPage >= splitStart + splitLength) continue;
                splitGroup.add(block);
            }
            if (splitGroup.isEmpty()) {
                LOG.warn("Skipping split, could not find row group in: " + oldSplit);
                return null;
            }
            FilterCompat.Filter filter = this.setFilter(this.jobConf, fileMetaData.getSchema());
            if (filter != null) {
                this.filtedBlocks = RowGroupFilter.filterRowGroups((FilterCompat.Filter)filter, splitGroup, (MessageType)fileMetaData.getSchema());
                if (this.filtedBlocks.isEmpty()) {
                    LOG.debug("All row groups are dropped due to filter predicates");
                    return null;
                }
                long droppedBlocks = splitGroup.size() - this.filtedBlocks.size();
                if (droppedBlocks > 0L) {
                    LOG.debug("Dropping " + droppedBlocks + " row groups that do not pass filter predicate");
                }
            } else {
                this.filtedBlocks = splitGroup;
            }
            if (HiveConf.getBoolVar((Configuration)conf, HiveConf.ConfVars.HIVE_PARQUET_TIMESTAMP_SKIP_CONVERSION)) {
                this.skipTimestampConversion = !Strings.nullToEmpty(fileMetaData.getCreatedBy()).startsWith("parquet-mr");
            }
            ParquetInputSplit split = new ParquetInputSplit(finalPath, splitStart, splitLength, oldSplit.getLocations(), this.filtedBlocks, readContext.getRequestedSchema().toString(), fileMetaData.getSchema().toString(), fileMetaData.getKeyValueMetaData(), readContext.getReadSupportMetadata());
            return split;
        }
        throw new IllegalArgumentException("Unknown split type: " + oldSplit);
    }

    public FilterCompat.Filter setFilter(JobConf conf, MessageType schema) {
        SearchArgument sarg = ConvertAstToSearchArg.createFromConf((Configuration)conf);
        if (sarg == null) {
            return null;
        }
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate(sarg, schema);
        if (p != null) {
            LOG.debug("PARQUET predicate push down generated.");
            ParquetInputFormat.setFilterPredicate((Configuration)conf, (FilterPredicate)p);
            return FilterCompat.get((FilterPredicate)p);
        }
        LOG.debug("No PARQUET predicate push down is generated.");
        return null;
    }

    public List<BlockMetaData> getFiltedBlocks() {
        return this.filtedBlocks;
    }

    public SerDeStats getStats() {
        return this.serDeStats;
    }
}

