/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.FileMetadataCache;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedSupport;
import org.apache.hadoop.hive.ql.io.InputFormatChecker;
import org.apache.hadoop.hive.ql.io.LlapCacheOnlyInputFormatInterface;
import org.apache.hadoop.hive.ql.io.parquet.VectorizedParquetInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.read.DataWritableReadSupport;
import org.apache.hadoop.hive.ql.io.parquet.read.ParquetRecordReaderWrapper;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.parquet.hadoop.ParquetInputFormat;

public class MapredParquetInputFormat
extends FileInputFormat<NullWritable, ArrayWritable>
implements InputFormatChecker,
VectorizedInputFormatInterface,
LlapCacheOnlyInputFormatInterface {
    private static final Logger LOG = LoggerFactory.getLogger(MapredParquetInputFormat.class);
    private final ParquetInputFormat<ArrayWritable> realInput;
    private final transient VectorizedParquetInputFormat vectorizedSelf;

    public MapredParquetInputFormat() {
        this((ParquetInputFormat<ArrayWritable>)new ParquetInputFormat(DataWritableReadSupport.class));
    }

    protected MapredParquetInputFormat(ParquetInputFormat<ArrayWritable> inputFormat) {
        this.realInput = inputFormat;
        this.vectorizedSelf = new VectorizedParquetInputFormat();
    }

    public RecordReader<NullWritable, ArrayWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        try {
            if (Utilities.getIsVectorized((Configuration)job)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using vectorized record reader");
                }
                return this.vectorizedSelf.getRecordReader(split, job, reporter);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using row-mode record reader");
            }
            return new ParquetRecordReaderWrapper(this.realInput, split, job, reporter);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Cannot create a RecordReaderWrapper", e);
        }
    }

    @Override
    public void injectCaches(FileMetadataCache metadataCache, DataCache dataCache, Configuration cacheConf) {
        this.vectorizedSelf.injectCaches(metadataCache, dataCache, cacheConf);
    }

    @Override
    public boolean validateInput(FileSystem fs, HiveConf conf, List<FileStatus> files) throws IOException {
        if (files.size() <= 0) {
            return false;
        }
        for (FileStatus file : files) {
            if (file.getLen() != 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public VectorizedSupport.Support[] getSupportedFeatures() {
        return null;
    }
}

