/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc.encoded;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import io.trino.hive.orc.OrcProto;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.Pool;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.DebugUtils;
import org.apache.hive.common.util.FixedSizedObjectPool;

public final class IoTrace {
    private static final Logger LOG = LoggerFactory.getLogger(IoTrace.class);
    private final long[] log;
    private int offset;
    private final boolean isAlwaysDump;
    private boolean hasDumped = false;
    public static final int TREE_READER_NEXT_VECTOR = 1;
    public static final int READING_STRIPE = 2;
    public static final int SARG_RESULT = 4;
    public static final int RANGES = 5;
    public static final int COLUMN_READ = 6;
    public static final int SKIP_STREAM = 7;
    public static final int ADD_STREAM = 8;
    public static final int START_RG = 9;
    public static final int START_COL = 10;
    public static final int START_STRIPE_STREAM = 11;
    public static final int START_STREAM = 12;
    public static final int START_READ = 13;
    public static final int UNCOMPRESSED_DATA = 14;
    public static final int PARTIAL_UNCOMPRESSED_DATA = 15;
    public static final int VALID_UNCOMPRESSEED_CHUNK = 16;
    public static final int CACHE_COLLISION = 17;
    public static final int ORC_CB = 18;
    public static final int INVALID_ORC_CB = 19;
    public static final int PARTIAL_CB = 20;
    public static final int COMPOSITE_ORC_CB = 21;
    public static final int SARG_RESULT2 = 22;
    private static int MAX_ELEMENT_BITS = 17;
    private static int MAX_ELEMENTS = (1 << MAX_ELEMENT_BITS) - 1;

    public IoTrace(int byteSize, boolean isAlwaysDump) {
        this.log = byteSize == 0 ? null : new long[byteSize >> 3];
        this.isAlwaysDump = isAlwaysDump;
    }

    public void reset() {
        if (this.isAlwaysDump && !this.hasDumped) {
            this.dumpLog(LOG);
        }
        this.offset = 0;
        this.hasDumped = false;
    }

    public void dumpLog(Logger logger) {
        this.hasDumped = true;
        int ix = 0;
        logger.info("Dumping LLAP IO trace; " + (this.offset << 3) + " bytes");
        while (ix < this.offset) {
            ix = IoTrace.dumpOneLine(ix, logger, this.log);
        }
    }

    private static int dumpOneLine(int ix, Logger logger, long[] log) {
        int event = IoTrace.getFirstInt(log[ix]);
        switch (event) {
            case 1: {
                logger.info(ix + ": TreeReader next vector " + IoTrace.getSecondInt(log[ix]));
                return ix + 1;
            }
            case 2: {
                logger.info(ix + ": Reading stripe " + IoTrace.getSecondInt(log[ix]) + " at " + log[ix + 1] + " length " + log[ix + 2]);
                return ix + 3;
            }
            case 4: {
                logger.info(ix + ": Reading " + log[ix + 1] + " rgs for stripe " + IoTrace.getSecondInt(log[ix]));
                return ix + 2;
            }
            case 22: {
                int rgsLength = (int)log[ix + 1];
                int elements = (rgsLength >> 6) + ((rgsLength & 0x3F) == 0 ? 0 : 1);
                boolean[] rgs = new boolean[rgsLength];
                int rgsOffset = 0;
                for (int i = 0; i < elements; ++i) {
                    long val = log[ix + i + 2];
                    int bitsInByte = Math.min(rgsLength - rgsOffset, 64);
                    int j = 0;
                    while (j < rgsOffset) {
                        rgs[rgsOffset + j] = (val & 1L) == 1L;
                        ++j;
                        val >>>= 1;
                    }
                    rgsOffset += bitsInByte;
                }
                logger.info(ix + ": Reading filtered rgs for stripe " + IoTrace.getSecondInt(log[ix]) + ": " + DebugUtils.toString(rgs));
                return ix + (elements + 2);
            }
            case 5: {
                int val = IoTrace.getSecondInt(log[ix]);
                RangesSrc src = RangesSrc.values()[val >>> MAX_ELEMENT_BITS];
                int rangeCount = val & (1 << MAX_ELEMENT_BITS) - 1;
                int currentOffset = ix + 3;
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < rangeCount) {
                    sb.append(IoTrace.printRange(currentOffset, log)).append(", ");
                    ++i;
                    currentOffset += 3;
                }
                logger.info(ix + ": Ranges for file " + log[ix + 1] + " (base offset " + log[ix + 2] + ") after " + (Object)((Object)src) + ": " + sb.toString());
                return ix + 3 + rangeCount * 3;
            }
            case 6: {
                logger.info(ix + ": Reading column " + IoTrace.getSecondInt(log[ix]) + " (included index " + IoTrace.getFirstInt(log[ix + 1]) + "; type " + OrcProto.ColumnEncoding.Kind.values()[IoTrace.getSecondInt(log[ix + 1])] + ")");
                return ix + 2;
            }
            case 7: {
                long streamOffset = log[ix + 1];
                logger.info(ix + ": Skipping stream for col " + IoTrace.getSecondInt(log[ix]) + " [" + streamOffset + ", " + (streamOffset + (long)IoTrace.getFirstInt(log[ix + 2])) + ") kind " + OrcProto.Stream.Kind.values()[IoTrace.getSecondInt(log[ix + 2])]);
                return ix + 3;
            }
            case 8: {
                long streamOffset = log[ix + 1];
                logger.info(ix + ": Adding stream for col " + IoTrace.getSecondInt(log[ix]) + " [" + streamOffset + ", " + (streamOffset + (long)IoTrace.getFirstInt(log[ix + 2])) + ") kind " + OrcProto.Stream.Kind.values()[IoTrace.getSecondInt(log[ix + 2])] + ", index " + IoTrace.getFirstInt(log[ix + 3]) + ", entire stream " + (IoTrace.getSecondInt(log[ix + 3]) == 1));
                return ix + 4;
            }
            case 9: {
                logger.info(ix + ": Starting rg " + IoTrace.getSecondInt(log[ix]));
                return ix + 1;
            }
            case 10: {
                logger.info(ix + ": Starting column " + IoTrace.getSecondInt(log[ix]));
                return ix + 1;
            }
            case 11: {
                logger.info(ix + ": Starting stripe-level stream " + OrcProto.Stream.Kind.values()[IoTrace.getSecondInt(log[ix])]);
                return ix + 1;
            }
            case 12: {
                long offset = log[ix + 1];
                int unlockLen = IoTrace.getFirstInt(log[ix + 2]);
                String unlockStr = unlockLen == Integer.MAX_VALUE ? "" : " unlock " + (offset + (long)unlockLen);
                logger.info(ix + ": Starting on stream " + OrcProto.Stream.Kind.values()[IoTrace.getSecondInt(log[ix])] + "[" + offset + ", " + (offset + (long)IoTrace.getSecondInt(log[ix + 2])) + ") " + unlockStr);
                return ix + 3;
            }
            case 13: {
                logger.info(ix + ": Starting read at 0x" + Integer.toHexString(IoTrace.getSecondInt(log[ix])));
                return ix + 1;
            }
            case 14: {
                long offset = log[ix + 1];
                logger.info(ix + ": Uncompressed data [" + offset + ", " + (offset + (long)IoTrace.getSecondInt(log[ix])) + ")");
                return ix + 2;
            }
            case 15: {
                long offset = log[ix + 1];
                logger.info(ix + ": Partial uncompressed data [" + offset + ", " + (offset + (long)IoTrace.getSecondInt(log[ix])) + ")");
                return ix + 2;
            }
            case 16: {
                logger.info(ix + ": Combining uncompressed data for cache buffer of length " + IoTrace.getSecondInt(log[ix]) + " from 0x" + Integer.toHexString((int)log[ix + 1]));
                return ix + 2;
            }
            case 17: {
                logger.info(ix + ": Replacing " + IoTrace.printRange(ix + 1, log) + " with 0x" + Integer.toHexString(IoTrace.getSecondInt(log[ix])));
                return ix + 4;
            }
            case 18: {
                long offset = log[ix + 1];
                int val = IoTrace.getSecondInt(log[ix]);
                boolean isUncompressed = (val & 1) == 1;
                int cbLength = val >>> 1;
                logger.info(ix + ": Found " + (isUncompressed ? "un" : "") + "compressed ORC CB [" + offset + ", " + (offset + (long)cbLength) + ")");
                return ix + 2;
            }
            case 19: {
                long offset = log[ix + 1];
                logger.info(ix + ": Found incomplete ORC CB [" + offset + ", " + (offset + (long)IoTrace.getSecondInt(log[ix])) + ")");
                return ix + 2;
            }
            case 20: {
                logger.info(ix + ": Found buffer with a part of ORC CB " + IoTrace.printRange(ix + 1, log));
                return ix + 4;
            }
            case 21: {
                logger.info(ix + ": Combined ORC CB from multiple buffers " + IoTrace.printRange(ix + 2, log) + " last chunk taken " + IoTrace.getSecondInt(log[ix]) + ", remaining " + log[ix + 1]);
                return ix + 5;
            }
        }
        throw new AssertionError((Object)("Unknown " + event));
    }

    private static long makeIntPair(int first, int second) {
        return (long)first << 32 | (long)second;
    }

    private static int getFirstInt(long result) {
        return (int)(result >>> 32);
    }

    private static int getSecondInt(long result) {
        return (int)(result & 0xFFFFFFFFL);
    }

    public void logTreeReaderNextVector(int idx) {
        int offset;
        if (this.log == null) {
            return;
        }
        if ((offset = this.offset++) + 1 > this.log.length) {
            return;
        }
        this.log[offset] = IoTrace.makeIntPair(1, idx);
    }

    public void logReadingStripe(int stripeIx, long stripeOffset, long length) {
        if (this.log == null) {
            return;
        }
        int offset = this.offset;
        if (offset + 3 > this.log.length) {
            return;
        }
        this.log[offset] = IoTrace.makeIntPair(2, stripeIx);
        this.log[offset + 1] = stripeOffset;
        this.log[offset + 2] = length;
        this.offset += 3;
    }

    public void logSargResult(int stripeIx, int rgCount) {
        if (this.log == null) {
            return;
        }
        int offset = this.offset;
        if (offset + 2 > this.log.length) {
            return;
        }
        this.log[offset] = IoTrace.makeIntPair(4, stripeIx);
        this.log[offset + 1] = rgCount;
        this.offset += 2;
    }

    public void logSargResult(int stripeIx, boolean[] rgsToRead) {
        if (this.log == null) {
            return;
        }
        int offset = this.offset;
        int elements = (rgsToRead.length >> 6) + ((rgsToRead.length & 0x3F) == 0 ? 0 : 1);
        if (offset + elements + 2 > this.log.length) {
            return;
        }
        this.log[offset] = IoTrace.makeIntPair(22, stripeIx);
        this.log[offset + 1] = rgsToRead.length;
        int i = 0;
        int valOffset = 0;
        while (i < elements) {
            int ix;
            long val = 0L;
            for (int j = 0; j < 64 && rgsToRead.length != (ix = valOffset + j); ++j) {
                if (!rgsToRead[ix]) continue;
                val |= (long)(1 << j);
            }
            this.log[offset + i + 2] = val;
            ++i;
            valOffset += 64;
        }
        this.offset += elements + 2;
    }

    public void logRanges(Object fileKey, long baseOffset, DiskRangeList range, RangesSrc src) {
        int elementCount;
        if (this.log == null) {
            return;
        }
        int offset = this.offset;
        if (offset + 3 > this.log.length) {
            return;
        }
        this.log[offset + 1] = fileKey instanceof Long ? (Long)fileKey : (long)fileKey.hashCode();
        this.log[offset + 2] = baseOffset;
        int currentOffset = offset + 3;
        for (elementCount = 0; range != null && elementCount < MAX_ELEMENTS && currentOffset + 3 <= this.log.length; ++elementCount) {
            this.logRange(range, currentOffset);
            currentOffset += 3;
            range = range.next;
        }
        this.log[offset] = IoTrace.makeIntPair(5, src.ordinal() << MAX_ELEMENT_BITS | elementCount);
        this.offset = currentOffset;
    }

    private void logRange(DiskRange range, int currentOffset) {
        this.log[currentOffset] = range.getOffset();
        this.log[currentOffset + 1] = range.getEnd();
        this.log[currentOffset + 2] = range.hasData() ? (long)System.identityHashCode(range.getData()) : 0L;
    }

    private static String printRange(int ix, long[] log) {
        return "[" + log[ix] + ", " + log[ix + 1] + "): 0x" + Integer.toHexString((int)log[ix + 2]);
    }

    public void logColumnRead(int colIx, int includedIx, OrcProto.ColumnEncoding.Kind kind) {
        if (this.log == null) {
            return;
        }
        int offset = this.offset;
        if (offset + 2 > this.log.length) {
            return;
        }
        this.log[offset] = IoTrace.makeIntPair(6, colIx);
        this.log[offset + 1] = IoTrace.makeIntPair(includedIx, kind.ordinal());
        this.offset += 2;
    }

    public void logSkipStream(int colIx, OrcProto.Stream.Kind streamKind, long streamOffset, long length) {
        if (this.log == null) {
            return;
        }
        int offset = this.offset;
        if (offset + 3 > this.log.length) {
            return;
        }
        this.log[offset] = IoTrace.makeIntPair(7, colIx);
        this.log[offset + 1] = streamOffset;
        this.log[offset + 2] = IoTrace.makeIntPair((int)length, streamKind.ordinal());
        this.offset += 3;
    }

    public void logAddStream(int colIx, OrcProto.Stream.Kind streamKind, long streamOffset, long length, int indexIx, boolean isEntire) {
        if (this.log == null) {
            return;
        }
        int offset = this.offset;
        if (offset + 4 > this.log.length) {
            return;
        }
        this.log[offset] = IoTrace.makeIntPair(8, colIx);
        this.log[offset + 1] = streamOffset;
        this.log[offset + 2] = IoTrace.makeIntPair((int)length, streamKind.ordinal());
        this.log[offset + 3] = IoTrace.makeIntPair(indexIx, isEntire ? 1 : 0);
        this.offset += 4;
    }

    public void logStartRg(int rgIx) {
        int offset;
        if (this.log == null) {
            return;
        }
        if ((offset = this.offset++) + 1 > this.log.length) {
            return;
        }
        this.log[offset] = IoTrace.makeIntPair(9, rgIx);
    }

    public void logStartCol(int colIx) {
        int offset;
        if (this.log == null) {
            return;
        }
        if ((offset = this.offset++) + 1 > this.log.length) {
            return;
        }
        this.log[offset] = IoTrace.makeIntPair(10, colIx);
    }

    public void logStartStripeStream(OrcProto.Stream.Kind kind) {
        int offset;
        if (this.log == null) {
            return;
        }
        if ((offset = this.offset++) + 1 > this.log.length) {
            return;
        }
        this.log[offset] = IoTrace.makeIntPair(11, kind.ordinal());
    }

    public void logStartStream(OrcProto.Stream.Kind kind, long cOffset, long endCOffset, long unlockUntilCOffset) {
        if (this.log == null) {
            return;
        }
        int offset = this.offset;
        if (offset + 3 > this.log.length) {
            return;
        }
        this.log[offset] = IoTrace.makeIntPair(12, kind.ordinal());
        this.log[offset + 1] = cOffset;
        long unlockLen = unlockUntilCOffset - cOffset;
        int unlockLenToSave = unlockLen >= 0L && unlockLen < Integer.MAX_VALUE ? (int)unlockLen : Integer.MAX_VALUE;
        this.log[offset + 2] = IoTrace.makeIntPair(unlockLenToSave, (int)(endCOffset - cOffset));
        this.offset += 3;
    }

    public void logStartRead(DiskRangeList current) {
        if (this.log == null) {
            return;
        }
        int offset = this.offset;
        if (offset + 1 > this.log.length) {
            return;
        }
        this.log[offset] = IoTrace.makeIntPair(13, current.hasData() ? System.identityHashCode(current.getData()) : 0);
        ++this.offset;
    }

    public void logUncompressedData(long dataOffset, long end) {
        if (this.log == null) {
            return;
        }
        int offset = this.offset;
        if (offset + 2 > this.log.length) {
            return;
        }
        this.log[offset] = IoTrace.makeIntPair(14, (int)(end - dataOffset));
        this.log[offset + 1] = dataOffset;
        this.offset += 2;
    }

    public void logPartialUncompressedData(long partOffset, long candidateEnd, boolean fromCache) {
        if (this.log == null) {
            return;
        }
        int offset = this.offset;
        if (offset + 2 > this.log.length) {
            return;
        }
        this.log[offset] = IoTrace.makeIntPair(15, (int)(candidateEnd - partOffset));
        this.log[offset + 1] = partOffset;
        this.offset += 2;
    }

    public void logValidUncompresseedChunk(int totalLength, DiskRange chunk) {
        if (this.log == null) {
            return;
        }
        int offset = this.offset;
        if (offset + 2 > this.log.length) {
            return;
        }
        this.log[offset] = IoTrace.makeIntPair(16, totalLength);
        this.log[offset + 1] = chunk.hasData() ? (long)System.identityHashCode(chunk.getData()) : 0L;
        this.offset += 2;
    }

    public void logCacheCollision(DiskRange replacedChunk, MemoryBuffer replacementBuffer) {
        if (this.log == null) {
            return;
        }
        int offset = this.offset;
        if (offset + 4 > this.log.length) {
            return;
        }
        this.log[offset] = IoTrace.makeIntPair(17, System.identityHashCode(replacementBuffer));
        this.logRange(replacedChunk, offset + 1);
        this.offset += 4;
    }

    public void logOrcCb(long cbStartOffset, int cbLength, boolean isUncompressed) {
        if (this.log == null) {
            return;
        }
        int offset = this.offset;
        if (offset + 2 > this.log.length) {
            return;
        }
        this.log[offset] = IoTrace.makeIntPair(18, cbLength << 1 | (isUncompressed ? 1 : 0));
        this.log[offset + 1] = cbStartOffset;
        this.offset += 2;
    }

    public void logInvalidOrcCb(long cbStartOffset, long end) {
        if (this.log == null) {
            return;
        }
        int offset = this.offset;
        if (offset + 2 > this.log.length) {
            return;
        }
        this.log[offset] = IoTrace.makeIntPair(19, (int)(end - cbStartOffset));
        this.log[offset + 1] = cbStartOffset;
        this.offset += 2;
    }

    public void logPartialCb(DiskRange current) {
        if (this.log == null) {
            return;
        }
        int offset = this.offset;
        if (offset + 4 > this.log.length) {
            return;
        }
        this.log[offset] = IoTrace.makeIntPair(20, 0);
        this.logRange(current, offset + 1);
        this.offset += 4;
    }

    public void logCompositeOrcCb(int lastChunkTaken, int lastChunkRemaining, DiskRange cc) {
        if (this.log == null) {
            return;
        }
        int offset = this.offset;
        if (offset + 5 > this.log.length) {
            return;
        }
        this.log[offset] = IoTrace.makeIntPair(21, lastChunkTaken);
        this.log[offset + 1] = lastChunkRemaining;
        this.logRange(cc, offset + 2);
        this.offset += 5;
    }

    public static FixedSizedObjectPool<IoTrace> createTracePool(Configuration conf) {
        final int ioTraceSize = (int)HiveConf.getSizeVar(conf, HiveConf.ConfVars.LLAP_IO_TRACE_SIZE);
        final boolean isAlwaysDump = HiveConf.getBoolVar(conf, HiveConf.ConfVars.LLAP_IO_TRACE_ALWAYS_DUMP);
        int ioThreads = HiveConf.getIntVar(conf, HiveConf.ConfVars.LLAP_IO_THREADPOOL_SIZE);
        return new FixedSizedObjectPool<IoTrace>(ioThreads, new Pool.PoolObjectHelper<IoTrace>(){

            @Override
            public IoTrace create() {
                return new IoTrace(ioTraceSize, isAlwaysDump);
            }

            @Override
            public void resetBeforeOffer(IoTrace t) {
                t.reset();
            }
        });
    }

    public static enum RangesSrc {
        PLAN,
        CACHE,
        DISK,
        PREREAD;

    }
}

