/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools;

import io.trino.hive.;
import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;

@.VisibleForTesting
public final class SQLGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(SQLGenerator.class.getName());
    private final DatabaseProduct dbProduct;
    private final Configuration conf;

    public SQLGenerator(DatabaseProduct dbProduct, Configuration conf) {
        this.dbProduct = dbProduct;
        this.conf = conf;
    }

    public List<String> createInsertValuesStmt(String tblColumns, List<String> rows) {
        if (rows == null || rows.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> insertStmts = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        switch (this.dbProduct) {
            case ORACLE: {
                if (rows.size() > 1) {
                    for (int numRows = 0; numRows < rows.size(); ++numRows) {
                        if (numRows % MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.DIRECT_SQL_MAX_ELEMENTS_VALUES_CLAUSE) == 0) {
                            if (numRows > 0) {
                                sb.append(" select * from dual");
                                insertStmts.add(sb.toString());
                            }
                            sb.setLength(0);
                            sb.append("insert all ");
                        }
                        sb.append("into ").append(tblColumns).append(" values(").append(rows.get(numRows)).append(") ");
                    }
                    sb.append("select * from dual");
                    insertStmts.add(sb.toString());
                    return insertStmts;
                }
            }
            case DERBY: 
            case MYSQL: 
            case POSTGRES: 
            case SQLSERVER: {
                for (int numRows = 0; numRows < rows.size(); ++numRows) {
                    if (numRows % MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.DIRECT_SQL_MAX_ELEMENTS_VALUES_CLAUSE) == 0) {
                        if (numRows > 0) {
                            insertStmts.add(sb.substring(0, sb.length() - 1));
                        }
                        sb.setLength(0);
                        sb.append("insert into ").append(tblColumns).append(" values");
                    }
                    sb.append('(').append(rows.get(numRows)).append("),");
                }
                insertStmts.add(sb.substring(0, sb.length() - 1));
                return insertStmts;
            }
        }
        String msg = "Unrecognized database product name <" + (Object)((Object)this.dbProduct) + ">";
        LOG.error(msg);
        throw new IllegalStateException(msg);
    }

    public String addForUpdateClause(String selectStatement) throws MetaException {
        switch (this.dbProduct) {
            case DERBY: {
                return selectStatement;
            }
            case ORACLE: 
            case MYSQL: 
            case POSTGRES: {
                return selectStatement + " for update";
            }
            case SQLSERVER: {
                String modifier = " with (updlock)";
                int wherePos = selectStatement.toUpperCase().indexOf(" WHERE ");
                if (wherePos < 0) {
                    return selectStatement + modifier;
                }
                return selectStatement.substring(0, wherePos) + modifier + selectStatement.substring(wherePos, selectStatement.length());
            }
        }
        String msg = "Unrecognized database product name <" + (Object)((Object)this.dbProduct) + ">";
        LOG.error(msg);
        throw new MetaException(msg);
    }

    public String addLimitClause(int numRows, String noSelectsqlQuery) throws MetaException {
        switch (this.dbProduct) {
            case DERBY: {
                return "select " + noSelectsqlQuery + " fetch first " + numRows + " rows only";
            }
            case MYSQL: 
            case POSTGRES: {
                return "select " + noSelectsqlQuery + " limit " + numRows;
            }
            case ORACLE: {
                return "select * from (select " + noSelectsqlQuery + ") where rownum <= " + numRows;
            }
            case SQLSERVER: {
                return "select TOP(" + numRows + ") " + noSelectsqlQuery;
            }
        }
        String msg = "Unrecognized database product name <" + (Object)((Object)this.dbProduct) + ">";
        LOG.error(msg);
        throw new MetaException(msg);
    }

    public DatabaseProduct getDbProduct() {
        return this.dbProduct;
    }
}

