/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.metrics.metrics2;

import io.trino.hive.$internal.com.codahale.metrics.Counter;
import io.trino.hive.$internal.com.codahale.metrics.ExponentiallyDecayingReservoir;
import io.trino.hive.$internal.com.codahale.metrics.Gauge;
import io.trino.hive.$internal.com.codahale.metrics.Meter;
import io.trino.hive.$internal.com.codahale.metrics.Metric;
import io.trino.hive.$internal.com.codahale.metrics.MetricRegistry;
import io.trino.hive.$internal.com.codahale.metrics.MetricSet;
import io.trino.hive.$internal.com.codahale.metrics.Timer;
import io.trino.hive.$internal.com.codahale.metrics.json.MetricsModule;
import io.trino.hive.$internal.com.codahale.metrics.jvm.BufferPoolMetricSet;
import io.trino.hive.$internal.com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import io.trino.hive.$internal.com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import io.trino.hive.$internal.com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import io.trino.hive.$internal.com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import io.trino.hive.$internal.com.fasterxml.jackson.databind.ObjectMapper;
import io.trino.hive.$internal.com.google.common.annotations.VisibleForTesting;
import io.trino.hive.$internal.com.google.common.base.Preconditions;
import io.trino.hive.$internal.com.google.common.base.Splitter;
import io.trino.hive.$internal.com.google.common.cache.CacheBuilder;
import io.trino.hive.$internal.com.google.common.cache.CacheLoader;
import io.trino.hive.$internal.com.google.common.cache.LoadingCache;
import io.trino.hive.$internal.com.google.common.collect.Lists;
import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.io.Closeable;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsScope;
import org.apache.hadoop.hive.common.metrics.common.MetricsVariable;
import org.apache.hadoop.hive.common.metrics.metrics2.CodahaleReporter;
import org.apache.hadoop.hive.common.metrics.metrics2.ConsoleMetricsReporter;
import org.apache.hadoop.hive.common.metrics.metrics2.JmxMetricsReporter;
import org.apache.hadoop.hive.common.metrics.metrics2.JsonFileMetricsReporter;
import org.apache.hadoop.hive.common.metrics.metrics2.MetricVariableRatioGauge;
import org.apache.hadoop.hive.common.metrics.metrics2.Metrics2Reporter;
import org.apache.hadoop.hive.common.metrics.metrics2.MetricsReporting;
import org.apache.hadoop.hive.conf.HiveConf;

public class CodahaleMetrics
implements Metrics {
    public static final Logger LOGGER = LoggerFactory.getLogger(CodahaleMetrics.class);
    public final MetricRegistry metricRegistry = new MetricRegistry();
    private final Lock timersLock = new ReentrantLock();
    private final Lock countersLock = new ReentrantLock();
    private final Lock gaugesLock = new ReentrantLock();
    private final Lock metersLock = new ReentrantLock();
    private LoadingCache<String, Timer> timers;
    private LoadingCache<String, Counter> counters;
    private LoadingCache<String, Meter> meters;
    private ConcurrentHashMap<String, Gauge> gauges;
    private HiveConf conf;
    private final Set<Closeable> reporters = new HashSet<Closeable>();
    private final ThreadLocal<HashMap<String, CodahaleMetricsScope>> threadLocalScopes = new ThreadLocal<HashMap<String, CodahaleMetricsScope>>(){

        @Override
        protected HashMap<String, CodahaleMetricsScope> initialValue() {
            return new HashMap<String, CodahaleMetricsScope>();
        }
    };

    public CodahaleMetrics(HiveConf conf) {
        this.conf = conf;
        this.timers = CacheBuilder.newBuilder().build(new CacheLoader<String, Timer>(){

            @Override
            public Timer load(String key) {
                Timer timer = new Timer(new ExponentiallyDecayingReservoir());
                CodahaleMetrics.this.metricRegistry.register(key, timer);
                return timer;
            }
        });
        this.counters = CacheBuilder.newBuilder().build(new CacheLoader<String, Counter>(){

            @Override
            public Counter load(String key) {
                Counter counter = new Counter();
                CodahaleMetrics.this.metricRegistry.register(key, counter);
                return counter;
            }
        });
        this.meters = CacheBuilder.newBuilder().build(new CacheLoader<String, Meter>(){

            @Override
            public Meter load(String key) {
                Meter meter = new Meter();
                CodahaleMetrics.this.metricRegistry.register(key, meter);
                return meter;
            }
        });
        this.gauges = new ConcurrentHashMap();
        this.registerAll("gc", new GarbageCollectorMetricSet());
        this.registerAll("buffers", new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        this.registerAll("memory", new MemoryUsageGaugeSet());
        this.registerAll("threads", new ThreadStatesGaugeSet());
        this.registerAll("classLoading", new ClassLoadingGaugeSet());
        this.initReporting();
    }

    @Override
    public void close() throws Exception {
        if (this.reporters != null) {
            for (Closeable closeable : this.reporters) {
                closeable.close();
            }
        }
        for (Map.Entry entry : this.metricRegistry.getMetrics().entrySet()) {
            this.metricRegistry.remove((String)entry.getKey());
        }
        this.timers.invalidateAll();
        this.counters.invalidateAll();
        this.meters.invalidateAll();
    }

    @Override
    public void startStoredScope(String name) {
        if (this.threadLocalScopes.get().containsKey(name)) {
            this.threadLocalScopes.get().get(name).open();
        } else {
            this.threadLocalScopes.get().put(name, new CodahaleMetricsScope(name));
        }
    }

    @Override
    public void endStoredScope(String name) {
        if (this.threadLocalScopes.get().containsKey(name)) {
            this.threadLocalScopes.get().get(name).close();
            this.threadLocalScopes.get().remove(name);
        }
    }

    public MetricsScope getStoredScope(String name) throws IllegalArgumentException {
        if (this.threadLocalScopes.get().containsKey(name)) {
            return this.threadLocalScopes.get().get(name);
        }
        throw new IllegalArgumentException("No metrics scope named " + name);
    }

    @Override
    public MetricsScope createScope(String name) {
        return new CodahaleMetricsScope(name);
    }

    @Override
    public void endScope(MetricsScope scope) {
        ((CodahaleMetricsScope)scope).close();
    }

    @Override
    public Long incrementCounter(String name) {
        return this.incrementCounter(name, 1L);
    }

    @Override
    public Long incrementCounter(String name, long increment) {
        String key = name;
        try {
            this.countersLock.lock();
            this.counters.get(key).inc(increment);
            Long l = this.counters.get(key).getCount();
            return l;
        }
        catch (ExecutionException ee) {
            throw new IllegalStateException("Error retrieving counter from the metric registry ", ee);
        }
        finally {
            this.countersLock.unlock();
        }
    }

    @Override
    public Long decrementCounter(String name) {
        return this.decrementCounter(name, 1L);
    }

    @Override
    public Long decrementCounter(String name, long decrement) {
        String key = name;
        try {
            this.countersLock.lock();
            this.counters.get(key).dec(decrement);
            Long l = this.counters.get(key).getCount();
            return l;
        }
        catch (ExecutionException ee) {
            throw new IllegalStateException("Error retrieving counter from the metric registry ", ee);
        }
        finally {
            this.countersLock.unlock();
        }
    }

    public void addGauge(String name, final MetricsVariable variable) {
        Gauge gauge = new Gauge(){

            public Object getValue() {
                return variable.getValue();
            }
        };
        this.addGaugeInternal(name, gauge);
    }

    @Override
    public void removeGauge(String name) {
        try {
            this.gaugesLock.lock();
            this.gauges.remove(name);
            if (this.metricRegistry.getGauges().containsKey(name)) {
                this.metricRegistry.remove(name);
            }
        }
        finally {
            this.gaugesLock.unlock();
        }
    }

    @Override
    public void addRatio(String name, MetricsVariable<Integer> numerator, MetricsVariable<Integer> denominator) {
        Preconditions.checkArgument(numerator != null, "Numerator must not be null");
        Preconditions.checkArgument(denominator != null, "Denominator must not be null");
        MetricVariableRatioGauge gauge = new MetricVariableRatioGauge(numerator, denominator);
        this.addGaugeInternal(name, gauge);
    }

    private void addGaugeInternal(String name, Gauge gauge) {
        try {
            this.gaugesLock.lock();
            this.gauges.put(name, gauge);
            if (this.metricRegistry.getGauges().containsKey(name)) {
                LOGGER.warn("A Gauge with name [" + name + "] already exists.  The old gauge will be overwritten, but this is not recommended");
                this.metricRegistry.remove(name);
            }
            this.metricRegistry.register(name, gauge);
        }
        finally {
            this.gaugesLock.unlock();
        }
    }

    @Override
    public void markMeter(String name) {
        String key = name;
        try {
            this.metersLock.lock();
            Meter meter = this.meters.get(name);
            meter.mark();
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Error retrieving meter " + name + " from the metric registry ", e);
        }
        finally {
            this.metersLock.unlock();
        }
    }

    private Timer getTimer(String name) {
        String key = name;
        try {
            Timer timer;
            this.timersLock.lock();
            Timer timer2 = timer = this.timers.get(key);
            return timer2;
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Error retrieving timer " + name + " from the metric registry ", e);
        }
        finally {
            this.timersLock.unlock();
        }
    }

    private void registerAll(String prefix, MetricSet metricSet) {
        for (Map.Entry<String, Metric> entry : metricSet.getMetrics().entrySet()) {
            if (entry.getValue() instanceof MetricSet) {
                this.registerAll(prefix + "." + entry.getKey(), (MetricSet)entry.getValue());
                continue;
            }
            this.metricRegistry.register(prefix + "." + entry.getKey(), entry.getValue());
        }
    }

    @VisibleForTesting
    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    @VisibleForTesting
    public String dumpJson() throws Exception {
        ObjectMapper jsonMapper = new ObjectMapper().registerModule(new MetricsModule(TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS, false));
        return jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString(this.metricRegistry);
    }

    private void initReporting() {
        if (!this.initCodahaleMetricsReporterClasses() && !this.initMetricsReporter()) {
            LOGGER.warn("Unable to initialize metrics reporting");
        }
        if (this.reporters.isEmpty()) {
            LOGGER.warn("No reporters configured for codahale metrics!");
        }
    }

    private boolean initCodahaleMetricsReporterClasses() {
        ArrayList<String> reporterClasses = Lists.newArrayList(Splitter.on(",").trimResults().omitEmptyStrings().split(this.conf.getVar(HiveConf.ConfVars.HIVE_CODAHALE_METRICS_REPORTER_CLASSES)));
        if (reporterClasses.isEmpty()) {
            return false;
        }
        for (String reporterClass : reporterClasses) {
            Class name = null;
            try {
                name = this.conf.getClassByName(reporterClass);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Unable to instantiate metrics reporter class " + reporterClass + " from conf HIVE_CODAHALE_METRICS_REPORTER_CLASSES", e);
                throw new IllegalArgumentException(e);
            }
            try {
                Constructor constructor = name.getConstructor(MetricRegistry.class, HiveConf.class);
                CodahaleReporter reporter = (CodahaleReporter)constructor.newInstance(new Object[]{this.metricRegistry, this.conf});
                reporter.start();
                this.reporters.add(reporter);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error("Unable to instantiate using constructor(MetricRegistry, HiveConf) for reporter " + reporterClass + " from conf HIVE_CODAHALE_METRICS_REPORTER_CLASSES", e);
                throw new IllegalArgumentException(e);
            }
        }
        return true;
    }

    private boolean initMetricsReporter() {
        ArrayList<String> metricsReporterNames = Lists.newArrayList(Splitter.on(",").trimResults().omitEmptyStrings().split(this.conf.getVar(HiveConf.ConfVars.HIVE_METRICS_REPORTER)));
        if (metricsReporterNames.isEmpty()) {
            return false;
        }
        MetricsReporting reporter = null;
        for (String metricsReportingName : metricsReporterNames) {
            try {
                reporter = MetricsReporting.valueOf(metricsReportingName.trim().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Invalid reporter name " + metricsReportingName, e);
                throw e;
            }
            CodahaleReporter codahaleReporter = null;
            switch (reporter) {
                case CONSOLE: {
                    codahaleReporter = new ConsoleMetricsReporter(this.metricRegistry, this.conf);
                    break;
                }
                case JMX: {
                    codahaleReporter = new JmxMetricsReporter(this.metricRegistry, this.conf);
                    break;
                }
                case JSON_FILE: {
                    codahaleReporter = new JsonFileMetricsReporter(this.metricRegistry, this.conf);
                    break;
                }
                case HADOOP2: {
                    codahaleReporter = new Metrics2Reporter(this.metricRegistry, this.conf);
                    break;
                }
                default: {
                    LOGGER.warn("Unhandled reporter " + (Object)((Object)reporter) + " provided.");
                }
            }
            if (codahaleReporter == null) continue;
            codahaleReporter.start();
            this.reporters.add(codahaleReporter);
        }
        return true;
    }

    public class CodahaleMetricsScope
    implements MetricsScope {
        private final String name;
        private final Timer timer;
        private Timer.Context timerContext;
        private boolean isOpen = false;

        private CodahaleMetricsScope(String name) {
            this.name = name;
            this.timer = CodahaleMetrics.this.getTimer(name);
            this.open();
        }

        public void open() {
            if (!this.isOpen) {
                this.isOpen = true;
                this.timerContext = this.timer.time();
                CodahaleMetrics.this.incrementCounter("active_calls_" + this.name);
            } else {
                LOGGER.warn("Scope named " + this.name + " is not closed, cannot be opened.");
            }
        }

        public void close() {
            if (this.isOpen) {
                this.timerContext.close();
                CodahaleMetrics.this.decrementCounter("active_calls_" + this.name);
            } else {
                LOGGER.warn("Scope named " + this.name + " is not open, cannot be closed.");
            }
            this.isOpen = false;
        }
    }
}

