/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.orc.impl;

import io.trino.hive.orc.impl.DynamicByteArray;
import io.trino.hive.orc.impl.DynamicIntArray;
import io.trino.hive.orc.impl.RedBlackTree;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.io.Text;

public class StringRedBlackTree
extends RedBlackTree {
    private final DynamicByteArray byteArray = new DynamicByteArray();
    private final DynamicIntArray keyOffsets;
    private final Text newKey = new Text();

    public StringRedBlackTree(int initialCapacity) {
        super(initialCapacity);
        this.keyOffsets = new DynamicIntArray(initialCapacity);
    }

    public int add(String value) {
        this.newKey.set(value);
        return this.addNewKey();
    }

    private int addNewKey() {
        if (this.add()) {
            int len = this.newKey.getLength();
            this.keyOffsets.add(this.byteArray.add(this.newKey.getBytes(), 0, len));
        }
        return this.lastAdd;
    }

    public int add(Text value) {
        this.newKey.set(value);
        return this.addNewKey();
    }

    public int add(byte[] bytes, int offset, int length) {
        this.newKey.set(bytes, offset, length);
        return this.addNewKey();
    }

    @Override
    protected int compareValue(int position) {
        int start = this.keyOffsets.get(position);
        int end = position + 1 == this.keyOffsets.size() ? this.byteArray.size() : this.keyOffsets.get(position + 1);
        return this.byteArray.compare(this.newKey.getBytes(), 0, this.newKey.getLength(), start, end - start);
    }

    private void recurse(int node, Visitor visitor, VisitorContextImpl context) throws IOException {
        if (node != -1) {
            this.recurse(this.getLeft(node), visitor, context);
            context.setPosition(node);
            visitor.visit(context);
            this.recurse(this.getRight(node), visitor, context);
        }
    }

    public void visit(Visitor visitor) throws IOException {
        this.recurse(this.root, visitor, new VisitorContextImpl());
    }

    @Override
    public void clear() {
        super.clear();
        this.byteArray.clear();
        this.keyOffsets.clear();
    }

    public void getText(Text result, int originalPosition) {
        int offset = this.keyOffsets.get(originalPosition);
        int length = originalPosition + 1 == this.keyOffsets.size() ? this.byteArray.size() - offset : this.keyOffsets.get(originalPosition + 1) - offset;
        this.byteArray.setText(result, offset, length);
    }

    public int getCharacterSize() {
        return this.byteArray.size();
    }

    @Override
    public long getSizeInBytes() {
        return this.byteArray.getSizeInBytes() + (long)this.keyOffsets.getSizeInBytes() + super.getSizeInBytes();
    }

    private class VisitorContextImpl
    implements VisitorContext {
        private int originalPosition;
        private int start;
        private int end;
        private final Text text = new Text();

        private VisitorContextImpl() {
        }

        @Override
        public int getOriginalPosition() {
            return this.originalPosition;
        }

        @Override
        public Text getText() {
            StringRedBlackTree.this.byteArray.setText(this.text, this.start, this.end - this.start);
            return this.text;
        }

        @Override
        public void writeBytes(OutputStream out) throws IOException {
            StringRedBlackTree.this.byteArray.write(out, this.start, this.end - this.start);
        }

        @Override
        public int getLength() {
            return this.end - this.start;
        }

        void setPosition(int position) {
            this.originalPosition = position;
            this.start = StringRedBlackTree.this.keyOffsets.get(this.originalPosition);
            this.end = position + 1 == StringRedBlackTree.this.keyOffsets.size() ? StringRedBlackTree.this.byteArray.size() : StringRedBlackTree.this.keyOffsets.get(this.originalPosition + 1);
        }
    }

    public static interface Visitor {
        public void visit(VisitorContext var1) throws IOException;
    }

    public static interface VisitorContext {
        public int getOriginalPosition();

        public void writeBytes(OutputStream var1) throws IOException;

        public Text getText();

        public int getLength();
    }
}

