/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.orc.impl;

import io.trino.hive.orc.impl.InStream;
import io.trino.hive.orc.impl.PositionProvider;
import io.trino.hive.orc.impl.RunLengthByteReader;
import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;

public final class BitFieldReader {
    private final RunLengthByteReader input;
    private int current;
    private byte currentIdx = (byte)8;

    public BitFieldReader(InStream input) {
        this.input = new RunLengthByteReader(input);
    }

    private void readByte() throws IOException {
        if (!this.input.hasNext()) {
            throw new EOFException("Read past end of bit field from " + this);
        }
        this.current = 0xFF & this.input.next();
        this.currentIdx = 0;
    }

    public int next() throws IOException {
        if (this.currentIdx > 7) {
            this.readByte();
        }
        this.currentIdx = (byte)(this.currentIdx + 1);
        return this.current >>> 8 - this.currentIdx & 1;
    }

    public void nextVector(LongColumnVector previous, long previousLen) throws IOException {
        previous.isRepeating = true;
        int i = 0;
        while ((long)i < previousLen) {
            previous.vector[i] = previous.noNulls || !previous.isNull[i] ? (long)this.next() : 1L;
            if (previous.isRepeating && i > 0 && (previous.vector[0] != previous.vector[i] || previous.isNull[0] != previous.isNull[i])) {
                previous.isRepeating = false;
            }
            ++i;
        }
    }

    public void seek(PositionProvider index) throws IOException {
        this.input.seek(index);
        int consumed = (int)index.getNext();
        if (consumed > 8) {
            throw new IllegalArgumentException("Seek past end of byte at " + consumed + " in " + this.input);
        }
        if (consumed != 0) {
            this.readByte();
            this.currentIdx = (byte)consumed;
        } else {
            this.currentIdx = (byte)8;
        }
    }

    public void skip(long totalBits) throws IOException {
        int availableBits = 8 - this.currentIdx;
        if (totalBits <= (long)availableBits) {
            this.currentIdx = (byte)((long)this.currentIdx + totalBits);
        } else {
            long bitsToSkip = totalBits - (long)availableBits;
            this.input.skip(bitsToSkip / 8L);
            this.current = this.input.next();
            this.currentIdx = (byte)(bitsToSkip % 8L);
        }
    }

    public String toString() {
        return "bit reader current: " + this.current + " current bit index: " + this.currentIdx + " from " + this.input;
    }
}

