/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenConstants;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractScalaCodegen;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class ScalazClientCodegen
extends AbstractScalaCodegen
implements CodegenConfig {
    public ScalazClientCodegen() {
        this.outputFolder = "generated-code/scalaz";
        this.templateDir = "scalaz";
        this.embeddedTemplateDir = "scalaz";
        this.apiPackage = "io.swagger.client.api";
        this.modelPackage = "io.swagger.client.api";
        this.modelTemplateFiles.put("model.mustache", ".scala");
        this.apiTemplateFiles.put("api.mustache", ".scala");
        this.setReservedWordsLowerCase(Arrays.asList("path", "contentTypes", "contentType", "queryParams", "headerParams", "formParams", "postBody", "mp", "basePath", "apiInvoker", "abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield"));
        this.additionalProperties.put("apiPackage", this.apiPackage);
        this.supportingFiles.add(new SupportingFile("build.sbt.mustache", "", "build.sbt"));
        this.supportingFiles.add(new SupportingFile("dateTimeCodecs.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "DateTimeCodecs.scala"));
        this.supportingFiles.add(new SupportingFile("HelperCodecs.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "HelperCodecs.scala"));
        this.supportingFiles.add(new SupportingFile("QueryParamTypeclass.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "QueryParamTypeclass.scala"));
        this.importMapping.remove("List");
        this.importMapping.remove("Set");
        this.importMapping.remove("Map");
        this.importMapping.put("Date", "java.util.Date");
        this.importMapping.put("ListBuffer", "scala.collection.mutable.ListBuffer");
        this.typeMapping = new HashMap();
        this.typeMapping.put("enum", "NSString");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("byte", "Byte");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("char", "Char");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Any");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("number", "BigDecimal");
        this.typeMapping.put("date-time", "DateTime");
        this.typeMapping.put("date", "DateTime");
        this.instantiationTypes.put("array", "ListBuffer");
        this.instantiationTypes.put("map", "HashMap");
        this.additionalProperties.put("fnEnumEntry", new EnumEntryLambda());
        this.cliOptions.add(new CliOption("modelPropertyNaming", "Naming convention for the property: 'camelCase', 'PascalCase', 'snake_case' and 'original', which keeps the original name").defaultValue("camelCase"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("modelPropertyNaming")) {
            this.setModelPropertyNaming((String)this.additionalProperties.get("modelPropertyNaming"));
        }
    }

    public void setModelPropertyNaming(String naming) {
        if (!("original".equals(naming) || "camelCase".equals(naming) || "PascalCase".equals(naming) || "snake_case".equals(naming))) {
            throw new IllegalArgumentException("Invalid model property naming '" + naming + "'. Must be 'original', 'camelCase', " + "'PascalCase' or 'snake_case'");
        }
        this.modelPropertyNaming = naming;
    }

    public String getModelPropertyNaming() {
        return this.modelPropertyNaming;
    }

    @Override
    public String toVarName(String name) {
        if ("_".equals(name = this.sanitizeName(name))) {
            name = "_u";
        }
        if (name.matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = this.getNameUsingModelPropertyNaming(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.formatIdentifier(property.baseName, true);
    }

    public String getNameUsingModelPropertyNaming(String name) {
        switch (CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.valueOf(this.getModelPropertyNaming())) {
            case original: {
                return name;
            }
            case camelCase: {
                return ScalazClientCodegen.camelize(name, true);
            }
            case PascalCase: {
                return ScalazClientCodegen.camelize(name);
            }
            case snake_case: {
                return ScalazClientCodegen.underscore(name);
            }
        }
        throw new IllegalArgumentException("Invalid model property naming '" + name + "'. Must be 'original', 'camelCase', " + "'PascalCase' or 'snake_case'");
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "scalaz";
    }

    @Override
    public String getHelp() {
        return "Generates a Scalaz client library (beta) that uses http4s";
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            throw new RuntimeException(operationId + " (reserved word) cannot be used as method name");
        }
        return ScalazClientCodegen.camelize(operationId, true);
    }

    @Override
    public String toModelName(String name) {
        String sanitizedName = this.sanitizeName(this.modelNamePrefix + this.stripPackageName(name) + this.modelNameSuffix);
        String camelizedName = ScalazClientCodegen.camelize(sanitizedName);
        if (this.isReservedWord(camelizedName)) {
            String modelName = "Model" + camelizedName;
            LOGGER.warn(camelizedName + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (name.matches("^\\d.*")) {
            String modelName = "Model" + camelizedName;
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        return camelizedName;
    }

    private class EnumEntryLambda
    extends CustomLambda {
        private EnumEntryLambda() {
        }

        @Override
        public String formatFragment(String fragment) {
            return ScalazClientCodegen.this.formatIdentifier(fragment, true);
        }
    }

    private static abstract class CustomLambda
    implements Mustache.Lambda {
        private CustomLambda() {
        }

        public void execute(Template.Fragment frag, Writer out) throws IOException {
            StringWriter tempWriter = new StringWriter();
            frag.execute((Writer)tempWriter);
            out.write(this.formatFragment(tempWriter.toString()));
        }

        public abstract String formatFragment(String var1);
    }
}

