/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.util.Yaml;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGoCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected static Logger LOGGER = LoggerFactory.getLogger(AbstractGoCodegen.class);
    protected boolean withXml = false;
    protected String packageName = "swagger";

    public AbstractGoCodegen() {
        this.hideGenerationTimestamp = Boolean.FALSE;
        this.defaultIncludes = new HashSet<String>(Arrays.asList("map", "array"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("string", "bool", "uint", "uint32", "uint64", "int", "int32", "int64", "float32", "float64", "complex64", "complex128", "rune", "byte"));
        this.instantiationTypes.clear();
        this.typeMapping.clear();
        this.typeMapping.put("integer", "int32");
        this.typeMapping.put("long", "int64");
        this.typeMapping.put("number", "float32");
        this.typeMapping.put("float", "float32");
        this.typeMapping.put("double", "float64");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("UUID", "string");
        this.typeMapping.put("date", "string");
        this.typeMapping.put("DateTime", "time.Time");
        this.typeMapping.put("password", "string");
        this.typeMapping.put("File", "*os.File");
        this.typeMapping.put("file", "*os.File");
        this.typeMapping.put("binary", "string");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("object", "interface{}");
        this.typeMapping.put("UUID", "string");
        this.importMapping = new HashMap();
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "Go package name (convention: lowercase).").defaultValue("swagger"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return AbstractGoCodegen.camelize(name) + '_';
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name.replaceAll("-", "_"))).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = AbstractGoCodegen.camelize(name))) {
            name = this.escapeReservedWord(name);
        }
        if (name.matches("^\\d.*")) {
            name = "Var" + name;
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return AbstractGoCodegen.camelize(this.toVarName(name), true);
    }

    @Override
    public String toModelName(String name) {
        return AbstractGoCodegen.camelize(this.toModel(name));
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModel("model_" + name);
    }

    public String toModel(String name) {
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + "model_" + name);
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + "model_" + name);
            name = "model_" + name;
        }
        return AbstractGoCodegen.underscore(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return "api_" + AbstractGoCodegen.underscore(name);
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        char nameFirstChar = parameter.paramName.charAt(0);
        if (Character.isUpperCase(nameFirstChar)) {
            parameter.vendorExtensions.put("x-exportParamName", parameter.paramName);
        } else {
            StringBuilder sb = new StringBuilder(parameter.paramName);
            sb.setCharAt(0, Character.toUpperCase(nameFirstChar));
            parameter.vendorExtensions.put("x-exportParamName", sb.toString());
        }
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return "[]" + this.getTypeDeclaration(inner);
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "[string]" + this.getTypeDeclaration(inner);
        }
        String swaggerType = this.getSwaggerType(p);
        if (this.typeMapping.containsKey(swaggerType)) {
            return (String)this.typeMapping.get(swaggerType);
        }
        if (this.typeMapping.containsValue(swaggerType)) {
            return swaggerType;
        }
        if (this.languageSpecificPrimitives.contains(swaggerType)) {
            return swaggerType;
        }
        return this.toModelName(swaggerType);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return type;
    }

    @Override
    public String toOperationId(String operationId) {
        String sanitizedOperationId = this.sanitizeName(operationId);
        if (this.isReservedWord(sanitizedOperationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + AbstractGoCodegen.camelize("call_" + operationId));
            sanitizedOperationId = "call_" + sanitizedOperationId;
        }
        return AbstractGoCodegen.camelize(sanitizedOperationId);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map objectMap = (Map)objs.get("operations");
        List operations = (List)objectMap.get("operation");
        for (CodegenOperation operation : operations) {
            operation.httpMethod = AbstractGoCodegen.camelize(operation.httpMethod.toLowerCase());
        }
        List imports = (List)objs.get("imports");
        if (imports == null) {
            return objs;
        }
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            String _import = (String)((Map)iterator.next()).get("import");
            if (!_import.startsWith(this.apiPackage())) continue;
            iterator.remove();
        }
        for (CodegenOperation operation : operations) {
            if (operation.pathParams == null || operation.pathParams.size() <= 0) continue;
            imports.add(this.createMapping("import", "fmt"));
            break;
        }
        boolean addedOptionalImport = false;
        boolean addedTimeImport = false;
        boolean addedOSImport = false;
        for (CodegenOperation operation : operations) {
            for (CodegenParameter param : operation.allParams) {
                if (!addedOSImport && param.dataType == "*os.File") {
                    imports.add(this.createMapping("import", "os"));
                    addedOSImport = true;
                }
                if (param.required && !addedTimeImport && param.dataType == "time.Time") {
                    imports.add(this.createMapping("import", "time"));
                    addedTimeImport = true;
                }
                if (param.required || !param.isPrimitiveType) continue;
                if (!addedOptionalImport) {
                    imports.add(this.createMapping("import", "github.com/antihax/optional"));
                    addedOptionalImport = true;
                }
                if (param.dataType == "time.Time") {
                    param.vendorExtensions.put("x-optionalDataType", "Time");
                    continue;
                }
                param.vendorExtensions.put("x-optionalDataType", param.dataType.substring(0, 1).toUpperCase() + param.dataType.substring(1));
            }
        }
        List recursiveImports = (List)objs.get("imports");
        if (recursiveImports == null) {
            return objs;
        }
        ListIterator<Map<String, String>> listIterator = imports.listIterator();
        while (listIterator.hasNext()) {
            String _import = (String)((Map)listIterator.next()).get("import");
            if (!this.importMapping.containsKey(_import)) continue;
            listIterator.add(this.createMapping("import", (String)this.importMapping.get(_import)));
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List imports = (List)objs.get("imports");
        String prefix = this.modelPackage();
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            String _import = (String)((Map)iterator.next()).get("import");
            if (!_import.startsWith(prefix)) continue;
            iterator.remove();
        }
        boolean addedTimeImport = false;
        boolean addedOSImport = false;
        List models = (List)objs.get("models");
        for (Map m : models) {
            Object v = m.get("model");
            if (!(v instanceof CodegenModel)) continue;
            CodegenModel model = (CodegenModel)v;
            for (CodegenProperty param : model.vars) {
                if (!addedTimeImport && param.baseType == "time.Time") {
                    imports.add(this.createMapping("import", "time"));
                    addedTimeImport = true;
                }
                if (addedOSImport || param.baseType != "*os.File") continue;
                imports.add(this.createMapping("import", "os"));
                addedOSImport = true;
            }
        }
        List recursiveImports = (List)objs.get("imports");
        if (recursiveImports == null) {
            return objs;
        }
        ListIterator<Map<String, String>> listIterator = imports.listIterator();
        while (listIterator.hasNext()) {
            String _import = (String)((Map)listIterator.next()).get("import");
            if (!this.importMapping.containsKey(_import)) continue;
            listIterator.add(this.createMapping("import", (String)this.importMapping.get(_import)));
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        Swagger swagger = (Swagger)objs.get("swagger");
        if (swagger != null) {
            try {
                objs.put("swagger-yaml", Yaml.mapper().writeValueAsString((Object)swagger));
            }
            catch (JsonProcessingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    protected boolean needToImport(String type) {
        return !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    public Map<String, String> createMapping(String key, String value) {
        HashMap<String, String> customImport = new HashMap<String, String>();
        customImport.put(key, value);
        return customImport;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            return value;
        }
        return this.escapeText(value);
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "EMPTY";
        }
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            String varName = name;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        if (this.getSymbolName(name) != null) {
            return this.getSymbolName(name).toUpperCase();
        }
        String enumName = this.sanitizeName(AbstractGoCodegen.underscore(name).toUpperCase());
        enumName = enumName.replaceFirst("^_", "");
        if (this.isReservedWord(enumName = enumName.replaceFirst("_$", "")) || enumName.matches("\\d.*")) {
            return this.escapeReservedWord(enumName);
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = AbstractGoCodegen.underscore(this.toModelName(property.name)).toUpperCase();
        if ((enumName = enumName.replace("[]", "")).matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    public void setWithXml(boolean withXml) {
        this.withXml = withXml;
    }
}

