/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.utils.ModelUtils;
import io.swagger.models.Model;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.util.Json;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractEiffelCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Set<String> parentModels = new HashSet<String>();
    private final Multimap<String, CodegenModel> childrenByParent = ArrayListMultimap.create();

    public AbstractEiffelCodegen() {
        this.hideGenerationTimestamp = Boolean.FALSE;
        this.setReservedWordsLowerCase(Arrays.asList("across", "agent", "alias", "all", "and", "as", "assign", "attribute", "check", "class", "convert", "create", "Current", "debug", "deferred", "do", "else", "elseif", "end", "ensure", "expanded", "export", "external", "False", "feature", "from", "frozen", "if", "implies", "inherit", "inspect", "invariant", "like", "local", "loop", "not", "note", "obsolete", "old", "once", "only", "or", "Precursor", "redefine", "rename", "require", "rescue", "Result", "retry", "select", "separate", "then", "True", "TUPLE", "undefine", "until", "variant", "Void", "when", "xor"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("map", "array"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("BOOLEAN", "INTEGER_8", "INTEGER_16", "INTEGER_32", "INTEGER_64", "NATURAL_8", "NATURAL_16", "NATURAL_32", "NATURAL_64", "REAL_32", "REAL_64"));
        this.instantiationTypes.clear();
        this.typeMapping.clear();
        this.typeMapping.put("integer", "INTEGER_32");
        this.typeMapping.put("long", "INTEGER_64");
        this.typeMapping.put("number", "REAL_32");
        this.typeMapping.put("float", "REAL_32");
        this.typeMapping.put("double", "REAL_64");
        this.typeMapping.put("boolean", "BOOLEAN");
        this.typeMapping.put("string", "STRING_32");
        this.typeMapping.put("UUID", "UUID");
        this.typeMapping.put("date", "DATE");
        this.typeMapping.put("DateTime", "DATE_TIME");
        this.typeMapping.put("date-time", "DATE_TIME");
        this.typeMapping.put("password", "STRING");
        this.typeMapping.put("File", "FILE");
        this.typeMapping.put("file", "FILE");
        this.typeMapping.put("binary", "STRING_32");
        this.typeMapping.put("ByteArray", "ARRAY [NATURAL_8]");
        this.typeMapping.put("object", "ANY");
        this.typeMapping.put("map", "STRING_TABLE");
        this.typeMapping.put("array", "LIST");
        this.typeMapping.put("list", "LIST");
        this.instantiationTypes.put("array", "ARRAYED_LIST");
        this.instantiationTypes.put("list", "ARRAYED_LIST");
        this.instantiationTypes.put("map", "STRING_TABLE");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "Eiffel Cluster name (convention: lowercase).").defaultValue("swagger"));
        this.cliOptions.add(new CliOption("packageVersion", "Eiffel package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        if (name.matches("^\\d.*")) {
            return "var_" + name;
        }
        return "var_" + name;
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name.replaceAll("-", "_"))).matches("^[A-Z_]*$")) {
            return name;
        }
        if ((name = this.unCamelize(name)).startsWith("_")) {
            name = "var" + name;
        }
        if (this.isReservedWord(name)) {
            name = this.escapeReservedWord(name);
        }
        if (name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name).toLowerCase();
    }

    @Override
    public String toModelName(String name) {
        return this.toModelFilename(name).toUpperCase();
    }

    @Override
    public String toModelFilename(String name) {
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + "model_" + name);
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + "model_" + name);
            name = "model_" + name;
        }
        return AbstractEiffelCodegen.underscore(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return AbstractEiffelCodegen.underscore(name) + "_api";
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiName(name).toLowerCase() + "_test";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DEFAULT_API";
        }
        return name.toUpperCase() + "_API";
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        char firstChar = parameter.paramName.charAt(0);
        if (Character.isUpperCase(firstChar)) {
            parameter.vendorExtensions.put("x-exportParamName", parameter.paramName);
        }
        StringBuilder sb = new StringBuilder(parameter.paramName);
        sb.setCharAt(0, Character.toUpperCase(firstChar));
        parameter.vendorExtensions.put("x-exportParamName", sb.toString());
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        if (!Strings.isNullOrEmpty((String)model.parent)) {
            this.parentModels.add(model.parent);
            if (!this.childrenByParent.containsEntry((Object)model.parent, (Object)model)) {
                this.childrenByParent.put((Object)model.parent, (Object)model);
            }
        }
        if (!Strings.isNullOrEmpty((String)model.parentSchema)) {
            model.parentSchema = model.parentSchema.toLowerCase();
        }
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return "LIST [" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        String swaggerType = this.getSwaggerType(p);
        if (this.typeMapping.containsKey(swaggerType)) {
            return (String)this.typeMapping.get(swaggerType);
        }
        if (this.typeMapping.containsValue(swaggerType)) {
            return swaggerType;
        }
        if (this.languageSpecificPrimitives.contains(swaggerType)) {
            return swaggerType;
        }
        return this.toModelName(swaggerType);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return type;
    }

    @Override
    public String toOperationId(String operationId) {
        String sanitizedOperationId = this.sanitizeName(operationId);
        if (this.isReservedWord(sanitizedOperationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + AbstractEiffelCodegen.camelize("call_" + operationId));
            sanitizedOperationId = "call_" + sanitizedOperationId;
        }
        sanitizedOperationId = this.unCamelize(sanitizedOperationId);
        return this.toEiffelFeatureStyle(sanitizedOperationId);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        List recursiveImports;
        Map objectMap = (Map)objs.get("operations");
        List operations = (List)objectMap.get("operation");
        for (CodegenOperation operation : operations) {
            operation.httpMethod = AbstractEiffelCodegen.camelize(operation.httpMethod.toLowerCase());
        }
        List imports = (List)objs.get("imports");
        if (imports == null) {
            return objs;
        }
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            String _import = (String)((Map)iterator.next()).get("import");
            if (!_import.startsWith(this.apiPackage())) continue;
            iterator.remove();
        }
        for (CodegenOperation operation : operations) {
            if (operation.returnBaseType == null || !this.needToImport(operation.returnBaseType)) continue;
            imports.add(this.createMapping("import", "encoding/json"));
            break;
        }
        for (CodegenOperation operation : operations) {
            if (operation.pathParams == null || operation.pathParams.size() <= 0) continue;
            imports.add(this.createMapping("import", "fmt"));
            break;
        }
        if ((recursiveImports = (List)objs.get("imports")) == null) {
            return objs;
        }
        ListIterator<Map<String, String>> listIterator = imports.listIterator();
        while (listIterator.hasNext()) {
            String _import = (String)((Map)listIterator.next()).get("import");
            if (!this.importMapping.containsKey(_import)) continue;
            listIterator.add(this.createMapping("import", (String)this.importMapping.get(_import)));
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> models) {
        Map<String, Object> processed = super.postProcessAllModels(models);
        this.postProcessParentModels(models);
        return processed;
    }

    private void postProcessParentModels(Map<String, Object> models) {
        for (String parent : this.parentModels) {
            CodegenModel parentModel = ModelUtils.getModelByName(parent, models);
            Collection childrenModels = this.childrenByParent.get((Object)parent);
            for (CodegenModel child : childrenModels) {
                this.processParentPropertiesInChildModel(parentModel, child);
            }
        }
    }

    private void processParentPropertiesInChildModel(CodegenModel parent, CodegenModel child) {
        HashMap<String, CodegenProperty> childPropertiesByName = new HashMap<String, CodegenProperty>(child.vars.size());
        for (CodegenProperty childProperty : child.vars) {
            childPropertiesByName.put(childProperty.name, childProperty);
        }
        if (parent != null) {
            for (CodegenProperty parentProperty : parent.vars) {
                CodegenProperty duplicatedByParent = (CodegenProperty)childPropertiesByName.get(parentProperty.name);
                if (duplicatedByParent == null) continue;
                duplicatedByParent.isInherited = true;
            }
        }
    }

    @Override
    public CodegenModel fromModel(String name, Model model, Map<String, Model> allDefinitions) {
        CodegenModel codegenModel = super.fromModel(name, model, allDefinitions);
        if (allDefinitions != null && codegenModel.parentSchema != null && codegenModel.hasEnums) {
            Model parentModel = allDefinitions.get(codegenModel.parentSchema);
            CodegenModel parentCodegenModel = super.fromModel(codegenModel.parent, parentModel);
            codegenModel = AbstractEiffelCodegen.reconcileInlineEnums(codegenModel, parentCodegenModel);
        }
        return codegenModel;
    }

    private static CodegenModel reconcileInlineEnums(CodegenModel codegenModel, CodegenModel parentCodegenModel) {
        if (!parentCodegenModel.hasEnums) {
            return codegenModel;
        }
        List<CodegenProperty> parentModelCodegenProperties = parentCodegenModel.vars;
        List<CodegenProperty> codegenProperties = codegenModel.vars;
        boolean removedChildEnum = false;
        for (CodegenProperty parentModelCodegenPropery : parentModelCodegenProperties) {
            if (!parentModelCodegenPropery.isEnum) continue;
            Iterator<CodegenProperty> iterator = codegenProperties.iterator();
            while (iterator.hasNext()) {
                CodegenProperty codegenProperty = iterator.next();
                if (!codegenProperty.isEnum || !codegenProperty.equals(parentModelCodegenPropery)) continue;
                iterator.remove();
                removedChildEnum = true;
            }
        }
        if (removedChildEnum) {
            int count = 0;
            int numVars = codegenProperties.size();
            for (CodegenProperty codegenProperty : codegenProperties) {
                codegenProperty.hasMore = ++count < numVars;
            }
            codegenModel.vars = codegenProperties;
        }
        return codegenModel;
    }

    @Override
    protected boolean needToImport(String type) {
        return !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    public Map<String, String> createMapping(String key, String value) {
        HashMap<String, String> customImport = new HashMap<String, String>();
        customImport.put(key, value);
        return customImport;
    }

    @Override
    public String toInstantiationType(Property p) {
        if (p instanceof MapProperty) {
            MapProperty ap = (MapProperty)p;
            Property additionalProperties2 = ap.getAdditionalProperties();
            String type = additionalProperties2.getType();
            if (null == type) {
                LOGGER.error("No Type defined for Additional Property " + additionalProperties2 + "\n" + "\tIn Property: " + p);
            }
            String inner = this.toModelName(this.getSwaggerType(additionalProperties2));
            return (String)this.instantiationTypes.get("map") + " [" + inner + "]";
        }
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            String inner = this.toModelName(this.getSwaggerType(ap.getItems()));
            return (String)this.instantiationTypes.get("array") + " [" + inner + "]";
        }
        return null;
    }

    public String unCamelize(String name) {
        return name.replaceAll("(.)(\\p{Upper})", "$1_$2").toLowerCase();
    }

    public String toEiffelFeatureStyle(String operationId) {
        if (operationId.startsWith("get_")) {
            return operationId.substring(4, operationId.length());
        }
        return operationId;
    }

    @Override
    protected void updatePropertyForArray(CodegenProperty property, CodegenProperty innerProperty) {
        if (innerProperty == null) {
            LOGGER.warn("skipping invalid array property " + Json.pretty((Object)property));
            return;
        }
        property.dataFormat = innerProperty.dataFormat;
        if (!this.languageSpecificPrimitives.contains(innerProperty.baseType)) {
            property.complexType = innerProperty.baseType;
        } else {
            property.isPrimitiveType = true;
        }
        property.items = innerProperty;
        if (this.isPropertyInnerMostEnum(property).booleanValue()) {
            // empty if block
        }
    }
}

