/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.config;

import io.swagger.codegen.config.CodegenConfigurator;
import io.swagger.codegen.utils.OptionUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public final class CodegenConfiguratorUtils {
    public static void applySystemPropertiesKvp(String systemProperties, CodegenConfigurator configurator) {
        Map<String, String> map = CodegenConfiguratorUtils.createMapFromKeyValuePairs(systemProperties);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            configurator.addSystemProperty(entry.getKey(), entry.getValue());
        }
    }

    public static void applyInstantiationTypesKvp(String instantiationTypes, CodegenConfigurator configurator) {
        Map<String, String> map = CodegenConfiguratorUtils.createMapFromKeyValuePairs(instantiationTypes);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            configurator.addInstantiationType(entry.getKey(), entry.getValue());
        }
    }

    public static void applyImportMappingsKvp(String importMappings, CodegenConfigurator configurator) {
        Map<String, String> map = CodegenConfiguratorUtils.createMapFromKeyValuePairs(importMappings);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            configurator.addImportMapping(entry.getKey().trim(), entry.getValue().trim());
        }
    }

    public static void applyTypeMappingsKvp(String typeMappings, CodegenConfigurator configurator) {
        Map<String, String> map = CodegenConfiguratorUtils.createMapFromKeyValuePairs(typeMappings);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            configurator.addTypeMapping(entry.getKey(), entry.getValue());
        }
    }

    public static void applyAdditionalPropertiesKvp(String additionalProperties, CodegenConfigurator configurator) {
        Map<String, String> map = CodegenConfiguratorUtils.createMapFromKeyValuePairs(additionalProperties);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            configurator.addAdditionalProperty(entry.getKey(), entry.getValue());
        }
    }

    public static void applyLanguageSpecificPrimitivesCsv(String languageSpecificPrimitives, CodegenConfigurator configurator) {
        Set<String> set = CodegenConfiguratorUtils.createSetFromCsvList(languageSpecificPrimitives);
        for (String item : set) {
            configurator.addLanguageSpecificPrimitive(item);
        }
    }

    public static void applyReservedWordsMappingsKvp(String reservedWordMappings, CodegenConfigurator configurator) {
        Map<String, String> map = CodegenConfiguratorUtils.createMapFromKeyValuePairs(reservedWordMappings);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            configurator.addAdditionalReservedWordMapping(entry.getKey(), entry.getValue());
        }
    }

    private static Set<String> createSetFromCsvList(String csvProperty) {
        List<String> values = OptionUtils.splitCommaSeparatedList(csvProperty);
        return new HashSet<String>(values);
    }

    private static Map<String, String> createMapFromKeyValuePairs(String commaSeparatedKVPairs) {
        List<Pair<String, String>> pairs = OptionUtils.parseCommaSeparatedTuples(commaSeparatedKVPairs);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Pair<String, String> pair : pairs) {
            result.put((String)pair.getLeft(), (String)pair.getRight());
        }
        return result;
    }
}

