/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.service;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.codegen.ClientOpts;
import io.swagger.codegen.CodegenConfigLoader;
import io.swagger.codegen.auth.AuthParser;
import io.swagger.codegen.v3.ClientOptInput;
import io.swagger.codegen.v3.CodegenArgument;
import io.swagger.codegen.v3.CodegenConfig;
import io.swagger.codegen.v3.config.CodegenConfigurator;
import io.swagger.codegen.v3.service.GenerationRequest;
import io.swagger.codegen.v3.service.Options;
import io.swagger.codegen.v3.service.exception.BadRequestException;
import io.swagger.models.Swagger;
import io.swagger.models.auth.AuthorizationValue;
import io.swagger.parser.SwaggerParser;
import io.swagger.v3.core.util.Json;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorUtil {
    protected static final Logger LOGGER = LoggerFactory.getLogger(GeneratorUtil.class);

    public static io.swagger.codegen.ClientOptInput getClientOptInputV2(GenerationRequest generationRequest) {
        Swagger swagger;
        LOGGER.debug("getClientOptInputV2 - start");
        Options options = generationRequest.getOptions();
        String inputSpec = null;
        inputSpec = generationRequest.getSpec() == null ? null : (!(generationRequest.getSpec() instanceof String) ? io.swagger.util.Json.pretty((Object)generationRequest.getSpec()) : (String)generationRequest.getSpec());
        String inputSpecURL = generationRequest.getSpecURL();
        String lang = generationRequest.getLang();
        GeneratorUtil.validateSpec(lang, inputSpec, inputSpecURL);
        LOGGER.debug("getClientOptInputV2 - spec validated");
        List authorizationValues = AuthParser.parse((String)generationRequest.getOptions().getAuth());
        if (generationRequest.getOptions().getAuthorizationValue() != null) {
            AuthorizationValue authorizationValue = new AuthorizationValue().value(generationRequest.getOptions().getAuthorizationValue().getValue()).keyName(generationRequest.getOptions().getAuthorizationValue().getKeyName()).type(generationRequest.getOptions().getAuthorizationValue().getType());
            authorizationValues.add(authorizationValue);
        }
        LOGGER.debug("getClientOptInputV2 - processed auth");
        if (StringUtils.isBlank((CharSequence)inputSpec)) {
            if (inputSpecURL != null) {
                swagger = !authorizationValues.isEmpty() ? new SwaggerParser().read(inputSpecURL, authorizationValues, true) : new SwaggerParser().read(inputSpecURL);
            } else {
                throw new BadRequestException("No swagger specification was supplied");
            }
            LOGGER.debug("getClientOptInputV2 - parsed inputSpecURL " + inputSpecURL);
        } else {
            try {
                JsonNode node = io.swagger.util.Json.mapper().readTree(inputSpec);
                swagger = !authorizationValues.isEmpty() ? new SwaggerParser().read(node, authorizationValues, true) : new SwaggerParser().read(node, true);
            }
            catch (Exception e) {
                LOGGER.error("Exception parsing input spec", (Throwable)e);
                throw new BadRequestException("The swagger specification supplied was not valid");
            }
            LOGGER.debug("getClientOptInputV2 - parsed inputSpec");
        }
        if (swagger == null) {
            throw new BadRequestException("The swagger specification supplied was not valid");
        }
        io.swagger.codegen.ClientOptInput clientOptInput = new io.swagger.codegen.ClientOptInput();
        ClientOpts clientOpts = new ClientOpts();
        io.swagger.codegen.CodegenConfig codegenConfig = null;
        try {
            codegenConfig = CodegenConfigLoader.forName((String)lang);
        }
        catch (RuntimeException e) {
            throw new BadRequestException("Unsupported target " + lang + " supplied");
        }
        codegenConfig.setOutputDir(generationRequest.getOptions().getOutputDir());
        codegenConfig.setInputSpec(inputSpec);
        if (StringUtils.isNotEmpty((CharSequence)options.getApiPackage())) {
            codegenConfig.additionalProperties().put("apiPackage", options.getApiPackage());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getModelPackage())) {
            codegenConfig.additionalProperties().put("modelPackage", options.getModelPackage());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getModelNamePrefix())) {
            codegenConfig.additionalProperties().put("modelNamePrefix", options.getModelNamePrefix());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getModelNameSuffix())) {
            codegenConfig.additionalProperties().put("modelNameSuffix", options.getModelNameSuffix());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getInvokerPackage())) {
            codegenConfig.additionalProperties().put("invokerPackage", options.getInvokerPackage());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getGroupId())) {
            codegenConfig.additionalProperties().put("groupId", options.getGroupId());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getArtifactId())) {
            codegenConfig.additionalProperties().put("artifactId", options.getArtifactId());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getArtifactVersion())) {
            codegenConfig.additionalProperties().put("artifactVersion", options.getArtifactVersion());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getLibrary())) {
            codegenConfig.setLibrary(options.getLibrary());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getGitUserId())) {
            codegenConfig.additionalProperties().put("gitUserId", options.getGitUserId());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getGitRepoId())) {
            codegenConfig.additionalProperties().put("gitRepoId", options.getGitRepoId());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getReleaseNote())) {
            codegenConfig.additionalProperties().put("releaseNote", options.getReleaseNote());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getHttpUserAgent())) {
            codegenConfig.additionalProperties().put("httpUserAgent", options.getHttpUserAgent());
        }
        if (options.getRemoveOperationIdPrefix() != null) {
            codegenConfig.setRemoveOperationIdPrefix(options.getRemoveOperationIdPrefix().booleanValue());
        }
        if (options.getSkipOverride() != null) {
            codegenConfig.setSkipOverwrite(options.getSkipOverride().booleanValue());
        }
        if (options.getInstantiationTypes() != null) {
            codegenConfig.instantiationTypes().putAll(options.getInstantiationTypes());
        }
        if (options.getImportMappings() != null) {
            codegenConfig.importMapping().putAll(options.getImportMappings());
        }
        if (options.getTypeMappings() != null) {
            codegenConfig.typeMapping().putAll(options.getTypeMappings());
        }
        if (options.getLanguageSpecificPrimitives() != null) {
            codegenConfig.languageSpecificPrimitives().addAll(options.getLanguageSpecificPrimitives());
        }
        if (options.getReservedWordsMappings() != null) {
            codegenConfig.reservedWordsMappings().putAll(options.getReservedWordsMappings());
        }
        if (options.getAdditionalProperties() != null) {
            codegenConfig.additionalProperties().putAll(options.getAdditionalProperties());
        }
        clientOptInput.opts(clientOpts).swagger(swagger);
        codegenConfig.additionalProperties().put("swagger", swagger);
        clientOptInput.setConfig(codegenConfig);
        LOGGER.debug("getClientOptInputV2 - end");
        return clientOptInput;
    }

    public static void validateSpec(String lang, String inputSpec, String inputSpecURL) {
        Validate.notEmpty((CharSequence)lang, (String)"language must be specified", (Object[])new Object[0]);
        if ((StringUtils.isBlank((CharSequence)inputSpec) || "{}".equals(inputSpec) || "{ }".equals(inputSpec)) && StringUtils.isBlank((CharSequence)inputSpecURL)) {
            throw new BadRequestException("input spec or URL must be specified");
        }
    }

    public static ClientOptInput getClientOptInput(GenerationRequest generationRequest) {
        LOGGER.debug("getClientOptInput - start");
        Options options = generationRequest.getOptions();
        String inputSpec = null;
        inputSpec = generationRequest.getSpec() == null ? null : (!(generationRequest.getSpec() instanceof String) ? Json.pretty((Object)generationRequest.getSpec()) : (String)generationRequest.getSpec());
        String inputSpecURL = generationRequest.getSpecURL();
        String lang = generationRequest.getLang();
        GeneratorUtil.validateSpec(lang, inputSpec, inputSpecURL);
        LOGGER.debug("getClientOptInput - validated");
        CodegenConfigurator configurator = new CodegenConfigurator();
        configurator.setOutputDir(generationRequest.getOptions().getOutputDir());
        configurator.setInputSpec(inputSpec);
        configurator.setInputSpecURL(inputSpecURL);
        if (StringUtils.isNotEmpty((CharSequence)lang)) {
            configurator.setLang(lang);
            GeneratorUtil.readCodegenArguments(configurator, options);
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getAuth())) {
            configurator.setAuth(options.getAuth());
        }
        if (options.getAuthorizationValue() != null) {
            configurator.setAuthorizationValue(options.getAuthorizationValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getApiPackage())) {
            configurator.setApiPackage(options.getApiPackage());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getModelPackage())) {
            configurator.setModelPackage(options.getModelPackage());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getModelNamePrefix())) {
            configurator.setModelNamePrefix(options.getModelNamePrefix());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getModelNameSuffix())) {
            configurator.setModelNameSuffix(options.getModelNameSuffix());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getInvokerPackage())) {
            configurator.setInvokerPackage(options.getInvokerPackage());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getGroupId())) {
            configurator.setGroupId(options.getGroupId());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getArtifactId())) {
            configurator.setArtifactId(options.getArtifactId());
        }
        if (options.getSkipOverride() != null) {
            configurator.setSkipOverwrite(options.getSkipOverride());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getArtifactVersion())) {
            configurator.setArtifactVersion(options.getArtifactVersion());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getLibrary())) {
            configurator.setLibrary(options.getLibrary());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getGitUserId())) {
            configurator.setGitUserId(options.getGitUserId());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getGitRepoId())) {
            configurator.setGitRepoId(options.getGitRepoId());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getReleaseNote())) {
            configurator.setReleaseNote(options.getReleaseNote());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getTemplateVersion())) {
            configurator.setTemplateVersion(options.getTemplateVersion());
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getHttpUserAgent())) {
            configurator.setHttpUserAgent(options.getHttpUserAgent());
        }
        if (options.getRemoveOperationIdPrefix() != null) {
            configurator.setRemoveOperationIdPrefix(options.getRemoveOperationIdPrefix());
        }
        if (options.getInstantiationTypes() != null) {
            for (Map.Entry<String, String> entry : options.getInstantiationTypes().entrySet()) {
                configurator.addInstantiationType(entry.getKey(), entry.getValue());
            }
        }
        if (options.getImportMappings() != null) {
            for (Map.Entry<String, String> entry : options.getImportMappings().entrySet()) {
                configurator.addImportMapping(entry.getKey(), entry.getValue());
            }
        }
        if (options.getTypeMappings() != null) {
            for (Map.Entry<String, Object> entry : options.getTypeMappings().entrySet()) {
                configurator.addTypeMapping(entry.getKey(), (String)entry.getValue());
            }
        }
        if (options.getAdditionalProperties() != null) {
            for (Map.Entry entry : options.getAdditionalProperties().entrySet()) {
                configurator.addAdditionalProperty((String)entry.getKey(), entry.getValue());
            }
        }
        if (options.getLanguageSpecificPrimitives() != null) {
            for (String string : options.getLanguageSpecificPrimitives()) {
                configurator.addLanguageSpecificPrimitive(string);
            }
        }
        if (options.getReservedWordsMappings() != null) {
            for (Map.Entry entry : options.getReservedWordsMappings().entrySet()) {
                configurator.addAdditionalReservedWordMapping((String)entry.getKey(), (String)entry.getValue());
            }
        }
        LOGGER.debug("getClientOptInput - end");
        return configurator.toClientOptInput();
    }

    private static void readCodegenArguments(CodegenConfigurator configurator, Options options) {
        if (options == null) {
            return;
        }
        CodegenConfig config = io.swagger.codegen.v3.CodegenConfigLoader.forName(configurator.getLang());
        if (config == null) {
            return;
        }
        List<CodegenArgument> arguments = config.readLanguageArguments();
        if (arguments == null || arguments.isEmpty()) {
            return;
        }
        for (CodegenArgument codegenArgument : arguments) {
            String value = options.getCodegenArguments().get(codegenArgument.getOption().substring(2));
            if (value == null) continue;
            codegenArgument.setValue(value);
        }
        configurator.setCodegenArguments(arguments);
    }
}

