/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.html;

import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.generators.DefaultCodegenConfig;
import io.swagger.codegen.v3.generators.SchemaHandler;
import io.swagger.codegen.v3.generators.util.OpenAPIUtil;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HtmlSchemaHandler
extends SchemaHandler {
    public HtmlSchemaHandler(DefaultCodegenConfig codegenConfig) {
        super(codegenConfig);
    }

    @Override
    public void processComposedSchemas(CodegenModel codegenModel, Schema schema, Map<String, CodegenModel> allModels) {
        if (!(schema instanceof ComposedSchema)) {
            super.processComposedSchemas(codegenModel, schema, allModels);
            return;
        }
        ComposedSchema composedSchema = (ComposedSchema)schema;
        if (composedSchema.getAllOf() == null || composedSchema.getAllOf().isEmpty()) {
            super.processComposedSchemas(codegenModel, (Schema)composedSchema, allModels);
            return;
        }
        List codegenProperties = codegenModel.vars;
        if (codegenProperties == null || codegenProperties.isEmpty()) {
            return;
        }
        for (CodegenProperty codegenProperty : codegenProperties) {
            Schema schemaProperty;
            if (!codegenProperty.getIsListContainer().booleanValue() || (schemaProperty = OpenAPIUtil.getPropertyFromAllOfSchema(codegenProperty.baseName, composedSchema.getAllOf(), this.codegenConfig.getOpenAPI())) == null || !(schemaProperty instanceof ArraySchema)) continue;
            this.processArrayItemSchema("", codegenProperty, (ArraySchema)schemaProperty, allModels);
            break;
        }
    }

    @Override
    protected CodegenModel processComposedSchema(CodegenModel codegenModel, ComposedSchema composedSchema, Map<String, CodegenModel> allModels) {
        List schemas = composedSchema.getOneOf();
        CodegenModel composedModel = this.createComposedModel("OneOf" + codegenModel.getName(), schemas);
        if (composedModel == null) {
            schemas = composedSchema.getAnyOf();
            composedModel = this.createComposedModel("AnyOf" + codegenModel.getName(), schemas);
            if (composedModel == null) {
                return null;
            }
        }
        this.addInterfaceModel(codegenModel, composedModel);
        this.addInterfaces(schemas, composedModel, allModels);
        if (composedModel.getName().startsWith("OneOf")) {
            codegenModel.vendorExtensions.put("oneOf-model", composedModel);
        } else if (composedModel.getName().startsWith("OneOf")) {
            codegenModel.vendorExtensions.put("anyOf-model", composedModel);
        }
        return null;
    }

    @Override
    protected CodegenModel processComposedSchema(String codegenModelName, CodegenProperty codegenProperty, ComposedSchema composedSchema, Map<String, CodegenModel> allModels) {
        List schemas = composedSchema.getOneOf();
        CodegenModel composedModel = this.createComposedModel("OneOf" + codegenModelName, schemas);
        if (composedModel == null) {
            schemas = composedSchema.getAnyOf();
            composedModel = this.createComposedModel("AnyOf" + codegenModelName, schemas);
            if (composedModel == null) {
                return null;
            }
        }
        if (composedModel.getName().startsWith("OneOf")) {
            codegenProperty.vendorExtensions.put("oneOf-model", composedModel);
        } else if (composedModel.getName().startsWith("AnyOf")) {
            codegenProperty.vendorExtensions.put("anyOf-model", composedModel);
        }
        ArrayList<String> modelNames = new ArrayList<String>();
        for (Schema interfaceSchema : schemas) {
            if (!StringUtils.isNotBlank((CharSequence)interfaceSchema.get$ref())) continue;
            String schemaName = OpenAPIUtil.getSimpleRef(interfaceSchema.get$ref());
            modelNames.add(this.codegenConfig.toModelName(schemaName));
        }
        composedModel.vendorExtensions.put("x-model-names", modelNames);
        return null;
    }

    @Override
    protected CodegenModel processArrayItemSchema(CodegenModel codegenModel, ArraySchema arraySchema, Map<String, CodegenModel> allModels) {
        Schema itemsSchema = arraySchema.getItems();
        if (itemsSchema instanceof ComposedSchema) {
            this.processComposedSchema(codegenModel, (ComposedSchema)itemsSchema, allModels);
        }
        return null;
    }

    @Override
    protected CodegenModel processArrayItemSchema(String codegenModelName, CodegenProperty codegenProperty, ArraySchema arraySchema, Map<String, CodegenModel> allModels) {
        Schema itemsSchema = arraySchema.getItems();
        if (itemsSchema instanceof ComposedSchema) {
            this.processComposedSchema(codegenModelName, codegenProperty.items, (ComposedSchema)itemsSchema, allModels);
        }
        return null;
    }
}

