/*
 * Decompiled with CFR 0.152.
 */
package org.openx.data.jsonserde.objectinspector;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.openx.data.jsonserde.objectinspector.JsonListObjectInspector;
import org.openx.data.jsonserde.objectinspector.JsonMapObjectInspector;
import org.openx.data.jsonserde.objectinspector.JsonStructOIOptions;
import org.openx.data.jsonserde.objectinspector.JsonStructObjectInspector;
import org.openx.data.jsonserde.objectinspector.JsonUnionObjectInspector;
import org.openx.data.jsonserde.objectinspector.primitive.JavaStringBinaryObjectInspector;
import org.openx.data.jsonserde.objectinspector.primitive.JavaStringBooleanObjectInspector;
import org.openx.data.jsonserde.objectinspector.primitive.JavaStringByteObjectInspector;
import org.openx.data.jsonserde.objectinspector.primitive.JavaStringDateObjectInspector;
import org.openx.data.jsonserde.objectinspector.primitive.JavaStringDecimalObjectInspector;
import org.openx.data.jsonserde.objectinspector.primitive.JavaStringDoubleObjectInspector;
import org.openx.data.jsonserde.objectinspector.primitive.JavaStringFloatObjectInspector;
import org.openx.data.jsonserde.objectinspector.primitive.JavaStringIntObjectInspector;
import org.openx.data.jsonserde.objectinspector.primitive.JavaStringLongObjectInspector;
import org.openx.data.jsonserde.objectinspector.primitive.JavaStringShortObjectInspector;
import org.openx.data.jsonserde.objectinspector.primitive.JavaStringTimestampObjectInspector;
import org.openx.data.jsonserde.objectinspector.primitive.JsonStringJavaObjectInspector;
import org.openx.data.jsonserde.objectinspector.primitive.TypeEntryShim;

public final class JsonObjectInspectorFactory {
    static ConcurrentHashMap<Pair<TypeInfo, JsonStructOIOptions>, ObjectInspector> cachedJsonObjectInspector = new ConcurrentHashMap();
    static ConcurrentHashMap<Pair<ArrayList<Object>, JsonStructOIOptions>, JsonUnionObjectInspector> cachedJsonUnionObjectInspector = new ConcurrentHashMap();
    static ConcurrentHashMap<Pair<ArrayList<Object>, JsonStructOIOptions>, JsonStructObjectInspector> cachedStandardStructObjectInspector = new ConcurrentHashMap();
    static ConcurrentHashMap<Pair<ArrayList<Object>, JsonStructOIOptions>, JsonListObjectInspector> cachedJsonListObjectInspector = new ConcurrentHashMap();
    static ConcurrentHashMap<Pair<ArrayList<Object>, JsonStructOIOptions>, JsonMapObjectInspector> cachedJsonMapObjectInspector = new ConcurrentHashMap();
    static final ConcurrentHashMap<Pair<PrimitiveTypeInfo, JsonStructOIOptions>, AbstractPrimitiveJavaObjectInspector> primitiveOICache = new ConcurrentHashMap();

    private JsonObjectInspectorFactory() {
        throw new InstantiationError("This class must not be instantiated.");
    }

    public static ObjectInspector getJsonObjectInspectorFromTypeInfo(TypeInfo typeInfo, JsonStructOIOptions options) {
        Pair key = Pair.of((Object)typeInfo, (Object)options);
        Object result = cachedJsonObjectInspector.get(key);
        if (result == null || typeInfo.getCategory() == ObjectInspector.Category.STRUCT) {
            switch (typeInfo.getCategory()) {
                case PRIMITIVE: {
                    PrimitiveTypeInfo pti = (PrimitiveTypeInfo)typeInfo;
                    result = JsonObjectInspectorFactory.getPrimitiveJavaObjectInspector(pti, options);
                    break;
                }
                case LIST: {
                    ObjectInspector elementObjectInspector = JsonObjectInspectorFactory.getJsonObjectInspectorFromTypeInfo(((ListTypeInfo)typeInfo).getListElementTypeInfo(), options);
                    result = JsonObjectInspectorFactory.getJsonListObjectInspector(elementObjectInspector, options);
                    break;
                }
                case MAP: {
                    MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                    ObjectInspector keyObjectInspector = JsonObjectInspectorFactory.getJsonObjectInspectorFromTypeInfo(mapTypeInfo.getMapKeyTypeInfo(), options);
                    ObjectInspector valueObjectInspector = JsonObjectInspectorFactory.getJsonObjectInspectorFromTypeInfo(mapTypeInfo.getMapValueTypeInfo(), options);
                    result = JsonObjectInspectorFactory.getJsonMapObjectInspector(keyObjectInspector, valueObjectInspector, options);
                    break;
                }
                case STRUCT: {
                    StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                    ArrayList fieldNames = structTypeInfo.getAllStructFieldNames();
                    ArrayList fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                    ArrayList<ObjectInspector> fieldObjectInspectors = new ArrayList<ObjectInspector>(fieldTypeInfos.size());
                    for (int i = 0; i < fieldTypeInfos.size(); ++i) {
                        fieldObjectInspectors.add(JsonObjectInspectorFactory.getJsonObjectInspectorFromTypeInfo((TypeInfo)fieldTypeInfos.get(i), options));
                    }
                    result = JsonObjectInspectorFactory.getJsonStructObjectInspector(fieldNames, fieldObjectInspectors, options);
                    break;
                }
                case UNION: {
                    LinkedList<ObjectInspector> ois = new LinkedList<ObjectInspector>();
                    for (TypeInfo ti : ((UnionTypeInfo)typeInfo).getAllUnionObjectTypeInfos()) {
                        ois.add(JsonObjectInspectorFactory.getJsonObjectInspectorFromTypeInfo(ti, options));
                    }
                    result = JsonObjectInspectorFactory.getJsonUnionObjectInspector(ois, options);
                    break;
                }
                default: {
                    result = null;
                }
            }
            cachedJsonObjectInspector.put((Pair<TypeInfo, JsonStructOIOptions>)key, (ObjectInspector)result);
        }
        return result;
    }

    public static JsonUnionObjectInspector getJsonUnionObjectInspector(List<ObjectInspector> ois, JsonStructOIOptions options) {
        ArrayList<Object> signature = new ArrayList<Object>();
        signature.add(ois);
        signature.add(options);
        Pair key = Pair.of(signature, (Object)options);
        JsonUnionObjectInspector result = cachedJsonUnionObjectInspector.get(key);
        if (result == null) {
            result = new JsonUnionObjectInspector(ois, options);
            cachedJsonUnionObjectInspector.put((Pair<ArrayList<Object>, JsonStructOIOptions>)key, result);
        }
        return result;
    }

    public static JsonStructObjectInspector getJsonStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, JsonStructOIOptions options) {
        ArrayList<Object> signature = new ArrayList<Object>();
        signature.add(structFieldNames);
        signature.add(structFieldObjectInspectors);
        signature.add(options);
        Pair key = Pair.of(signature, (Object)options);
        JsonStructObjectInspector result = cachedStandardStructObjectInspector.get(key);
        if (result == null) {
            result = new JsonStructObjectInspector(structFieldNames, structFieldObjectInspectors, options);
            cachedStandardStructObjectInspector.put((Pair<ArrayList<Object>, JsonStructOIOptions>)key, result);
        }
        return result;
    }

    public static JsonListObjectInspector getJsonListObjectInspector(ObjectInspector listElementObjectInspector, JsonStructOIOptions options) {
        ArrayList<ObjectInspector> signature = new ArrayList<ObjectInspector>();
        signature.add(listElementObjectInspector);
        Pair key = Pair.of(signature, (Object)options);
        JsonListObjectInspector result = cachedJsonListObjectInspector.get(key);
        if (result == null) {
            result = new JsonListObjectInspector(listElementObjectInspector);
            cachedJsonListObjectInspector.put((Pair<ArrayList<Object>, JsonStructOIOptions>)key, result);
        }
        return result;
    }

    public static JsonMapObjectInspector getJsonMapObjectInspector(ObjectInspector mapKeyObjectInspector, ObjectInspector mapValueObjectInspector, JsonStructOIOptions options) {
        ArrayList<ObjectInspector> signature = new ArrayList<ObjectInspector>();
        signature.add(mapKeyObjectInspector);
        signature.add(mapValueObjectInspector);
        Pair key = Pair.of(signature, (Object)options);
        JsonMapObjectInspector result = cachedJsonMapObjectInspector.get(key);
        if (result == null) {
            result = new JsonMapObjectInspector(mapKeyObjectInspector, mapValueObjectInspector);
            cachedJsonMapObjectInspector.put((Pair<ArrayList<Object>, JsonStructOIOptions>)key, result);
        }
        return result;
    }

    public static AbstractPrimitiveJavaObjectInspector getPrimitiveJavaObjectInspector(PrimitiveTypeInfo primitiveTypeInfo, JsonStructOIOptions options) {
        Pair key = Pair.of((Object)primitiveTypeInfo, (Object)options);
        if (!primitiveOICache.containsKey(key)) {
            if (primitiveTypeInfo == TypeEntryShim.booleanType) {
                primitiveOICache.put((Pair<PrimitiveTypeInfo, JsonStructOIOptions>)key, new JavaStringBooleanObjectInspector());
            } else if (primitiveTypeInfo == TypeEntryShim.byteType) {
                primitiveOICache.put((Pair<PrimitiveTypeInfo, JsonStructOIOptions>)key, new JavaStringByteObjectInspector());
            } else if (primitiveTypeInfo == TypeEntryShim.shortType) {
                primitiveOICache.put((Pair<PrimitiveTypeInfo, JsonStructOIOptions>)key, new JavaStringShortObjectInspector());
            } else if (primitiveTypeInfo == TypeEntryShim.intType) {
                primitiveOICache.put((Pair<PrimitiveTypeInfo, JsonStructOIOptions>)key, new JavaStringIntObjectInspector());
            } else if (primitiveTypeInfo == TypeEntryShim.longType) {
                primitiveOICache.put((Pair<PrimitiveTypeInfo, JsonStructOIOptions>)key, new JavaStringLongObjectInspector());
            } else if (primitiveTypeInfo == TypeEntryShim.floatType) {
                primitiveOICache.put((Pair<PrimitiveTypeInfo, JsonStructOIOptions>)key, new JavaStringFloatObjectInspector());
            } else if (primitiveTypeInfo == TypeEntryShim.doubleType) {
                primitiveOICache.put((Pair<PrimitiveTypeInfo, JsonStructOIOptions>)key, new JavaStringDoubleObjectInspector());
            } else if (primitiveTypeInfo == TypeEntryShim.binaryType) {
                primitiveOICache.put((Pair<PrimitiveTypeInfo, JsonStructOIOptions>)key, new JavaStringBinaryObjectInspector());
            } else if (primitiveTypeInfo == TypeEntryShim.dateType) {
                primitiveOICache.put((Pair<PrimitiveTypeInfo, JsonStructOIOptions>)key, new JavaStringDateObjectInspector());
            } else if (primitiveTypeInfo == TypeEntryShim.stringType) {
                primitiveOICache.put((Pair<PrimitiveTypeInfo, JsonStructOIOptions>)key, new JsonStringJavaObjectInspector());
            } else if (primitiveTypeInfo == TypeEntryShim.timestampType) {
                primitiveOICache.put((Pair<PrimitiveTypeInfo, JsonStructOIOptions>)key, new JavaStringTimestampObjectInspector(options.getTimestampFormats()));
            } else if (primitiveTypeInfo instanceof DecimalTypeInfo) {
                primitiveOICache.put((Pair<PrimitiveTypeInfo, JsonStructOIOptions>)key, new JavaStringDecimalObjectInspector((DecimalTypeInfo)primitiveTypeInfo));
            } else {
                primitiveOICache.put((Pair<PrimitiveTypeInfo, JsonStructOIOptions>)key, PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)primitiveTypeInfo));
            }
        }
        return primitiveOICache.get(key);
    }
}

