/*
 * Decompiled with CFR 0.152.
 */
package org.openx.data.jsonserde.objectinspector;

import io.starburst.openjson.JSONException;
import io.starburst.openjson.JSONObject;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.openx.data.jsonserde.objectinspector.JSONObjectMapAdapter;
import org.openx.data.jsonserde.objectinspector.JsonObjectInspectorUtils;

public class JsonMapObjectInspector
extends StandardMapObjectInspector {
    public JsonMapObjectInspector(ObjectInspector mapKeyObjectInspector, ObjectInspector mapValueObjectInspector) {
        super(mapKeyObjectInspector, mapValueObjectInspector);
    }

    public Map<?, ?> getMap(Object data) {
        if (JsonObjectInspectorUtils.checkObject(data) == null) {
            return null;
        }
        JSONObject jObj = (JSONObject)data;
        return new JSONObjectMapAdapter(jObj);
    }

    public int getMapSize(Object data) {
        if (JsonObjectInspectorUtils.checkObject(data) == null) {
            return -1;
        }
        JSONObject jObj = (JSONObject)data;
        return jObj.length();
    }

    public Object getMapValueElement(Object data, Object key) {
        if (JsonObjectInspectorUtils.checkObject(data) == null) {
            return null;
        }
        JSONObject jObj = (JSONObject)data;
        try {
            Object obj = jObj.get(key.toString());
            if (JSONObject.NULL == obj) {
                return null;
            }
            return obj;
        }
        catch (JSONException ex) {
            return null;
        }
    }
}

