/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProvider;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
@Qualifier(value="cachedModels")
public class CachingModelProvider
implements ModelProvider {
    private final LoadingCache<ModelContext, Optional<Model>> cache;
    private final ModelProvider delegate;

    @Autowired
    public CachingModelProvider(final @Qualifier(value="default") ModelProvider delegate) {
        this.delegate = delegate;
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(24L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<ModelContext, Optional<Model>>(){

            public Optional<Model> load(ModelContext key) {
                return delegate.modelFor(key);
            }
        });
    }

    @Override
    public Optional<Model> modelFor(ModelContext modelContext) {
        return (Optional)this.cache.getUnchecked((Object)modelContext);
    }

    @Override
    public Map<String, Model> dependencies(ModelContext modelContext) {
        return this.delegate.dependencies(modelContext);
    }
}

