/*
 * Decompiled with CFR 0.152.
 */
package io.spring.nohttp.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;

abstract class FileUtils {
    static String readTextFrom(File file) {
        FileUtils.assertValidFile(file);
        try {
            return new String(Files.readAllBytes(file.toPath()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read " + file, e);
        }
    }

    static void writeTextTo(String text, File file) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        FileUtils.assertValidFile(file);
        try (OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file));){
            writer.write(text);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not write to " + file, e);
        }
    }

    private static void assertValidFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
    }

    private FileUtils() {
    }
}

