/*
 * Decompiled with CFR 0.152.
 */
package io.spring.nohttp.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class DirScanner {
    private final File dir;
    private List<Predicate<File>> excludeDirs = new ArrayList<Predicate<File>>();
    private List<Predicate<File>> excludeFiles = new ArrayList<Predicate<File>>();

    private DirScanner(File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("dir cannot be null");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory");
        }
        this.dir = dir;
    }

    public static DirScanner create(File dir) {
        return new DirScanner(dir);
    }

    public DirScanner textFiles(boolean textFilesOnly) {
        if (textFilesOnly) {
            return this.excludeFiles(f -> !DirScanner.isTextFile(f));
        }
        return this;
    }

    private static boolean isTextFile(File file) {
        try {
            return new ProcessBuilder("grep", "-Iq", ".", file.getAbsolutePath()).directory(file.getParentFile()).start().waitFor() == 0;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not determine if " + file + " is a text file. Try explicitly providing the dir or files you want to process", e);
        }
    }

    public DirScanner excludeDirs(Predicate<File> dirExclusion) {
        if (dirExclusion == null) {
            throw new IllegalArgumentException("dirExclusion cannot be null");
        }
        this.excludeDirs.add(dirExclusion);
        return this;
    }

    public DirScanner excludeFiles(Predicate<File> fileExclusion) {
        if (fileExclusion == null) {
            throw new IllegalArgumentException("fileExclusion cannot be null");
        }
        this.excludeFiles.add(fileExclusion);
        return this;
    }

    public void scan(Consumer<File> fileProcessor) {
        if (fileProcessor == null) {
            throw new IllegalArgumentException("fileProcessor cannot be null");
        }
        FileScannerVisitor visitor = new FileScannerVisitor(fileProcessor);
        try {
            Files.walkFileTree(this.dir.toPath(), visitor);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    class FileScannerVisitor
    extends SimpleFileVisitor<Path> {
        private final Consumer<File> fileProcessor;

        FileScannerVisitor(Consumer<File> fileProcessor) {
            this.fileProcessor = fileProcessor;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            if (DirScanner.this.excludeDirs.stream().anyMatch(e -> e.test(dir.toFile()))) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (!DirScanner.this.excludeFiles.stream().anyMatch(e -> e.test(file.toFile()))) {
                this.fileProcessor.accept(file.toFile());
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

