/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle;

import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configurable;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Context;
import com.puppycrawl.tools.checkstyle.api.Contextualizable;
import com.puppycrawl.tools.checkstyle.api.FileSetCheck;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocVariableCheck;
import io.spring.javaformat.checkstyle.FilteredModuleFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.xml.sax.InputSource;

class SpringConfigurationLoader {
    private final Context context;
    private final FilteredModuleFactory moduleFactory;

    SpringConfigurationLoader(Context context, FilteredModuleFactory moduleFactory) {
        this.context = context;
        this.moduleFactory = moduleFactory;
    }

    public Collection<FileSetCheck> load(PropertyResolver propertyResolver) {
        Configuration config = this.loadConfiguration(this.loadConfigurationSource(), propertyResolver);
        return Arrays.stream(config.getChildren()).filter(this.moduleFactory::nonFiltered).map(this::load).collect(Collectors.toList());
    }

    private String loadConfigurationSource() {
        String string;
        block9: {
            InputStream stream = this.getClass().getResourceAsStream("spring-checkstyle.xml");
            try {
                int read;
                StringBuilder builder = new StringBuilder();
                byte[] buffer = new byte[4096];
                while ((read = stream.read(buffer)) > 0) {
                    builder.append(new String(buffer, 0, read, StandardCharsets.UTF_8));
                }
                string = this.preprocessConfigurationSource(builder.toString());
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            stream.close();
        }
        return string;
    }

    private String preprocessConfigurationSource(String source) {
        return source.replace("{{javadocVariableCheckScopeProperty}}", this.javadocVariableCheckScopeProperty());
    }

    private String javadocVariableCheckScopeProperty() {
        try {
            JavadocVariableCheck.class.getMethod("setScope", Scope.class);
            return "scope";
        }
        catch (NoSuchMethodException ex) {
            return "accessModifiers";
        }
    }

    private Configuration loadConfiguration(String source, PropertyResolver propertyResolver) {
        try {
            InputSource inputSource = new InputSource(new StringReader(source));
            return ConfigurationLoader.loadConfiguration((InputSource)inputSource, (PropertyResolver)propertyResolver, (ConfigurationLoader.IgnoredModulesOptions)ConfigurationLoader.IgnoredModulesOptions.EXECUTE);
        }
        catch (CheckstyleException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private FileSetCheck load(Configuration configuration) {
        Object module = this.createModule(configuration);
        if (!(module instanceof FileSetCheck)) {
            throw new IllegalStateException(configuration.getName() + " is not allowed");
        }
        return (FileSetCheck)module;
    }

    private Object createModule(Configuration configuration) {
        String name = configuration.getName();
        try {
            Object module = this.moduleFactory.createModule(name);
            this.initialize(configuration, module);
            return module;
        }
        catch (CheckstyleException ex) {
            throw new IllegalStateException("cannot initialize module " + name + " - " + ex.getMessage(), ex);
        }
    }

    private void initialize(Configuration configuration, Object module) throws CheckstyleException {
        if (module instanceof Contextualizable) {
            ((Contextualizable)module).contextualize(this.context);
        }
        if (module instanceof Configurable) {
            ((Configurable)module).configure(configuration);
        }
    }
}

