/*
 * Decompiled with CFR 0.152.
 */
package io.spring.release;

import io.spring.release.SpringReleaseTrainSpec;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SpringReleaseTrain {
    private final SpringReleaseTrainSpec releaseTrainSpec;

    public SpringReleaseTrain(SpringReleaseTrainSpec releaseTrainSpec) {
        this.releaseTrainSpec = releaseTrainSpec;
    }

    public Map<String, LocalDate> getTrainDates() {
        LinkedHashMap<String, LocalDate> releaseDates = new LinkedHashMap<String, LocalDate>();
        switch (this.releaseTrainSpec.getTrain()) {
            case ONE: {
                this.addTrainDate(releaseDates, "M1", Month.JANUARY);
                this.addTrainDate(releaseDates, "M2", Month.FEBRUARY);
                this.addTrainDate(releaseDates, "M3", Month.MARCH);
                this.addTrainDate(releaseDates, "RC1", Month.APRIL);
                this.addTrainDate(releaseDates, null, Month.MAY);
                break;
            }
            case TWO: {
                this.addTrainDate(releaseDates, "M1", Month.JULY);
                this.addTrainDate(releaseDates, "M2", Month.AUGUST);
                this.addTrainDate(releaseDates, "M3", Month.SEPTEMBER);
                this.addTrainDate(releaseDates, "RC1", Month.OCTOBER);
                this.addTrainDate(releaseDates, null, Month.NOVEMBER);
            }
        }
        return releaseDates;
    }

    public boolean isTrainDate(String version, LocalDate expectedDate) {
        return expectedDate.isEqual(this.getTrainDates().get(version));
    }

    public LocalDate getNextReleaseDate(LocalDate startDate) {
        LocalDate trainDate;
        LocalDate currentDate = startDate;
        do {
            trainDate = SpringReleaseTrain.calculateReleaseDate(Year.of(currentDate.getYear()), currentDate.getMonth(), this.releaseTrainSpec.getDayOfWeek().getDayOfWeek(), this.releaseTrainSpec.getWeekOfMonth().getDayOffset());
            currentDate = currentDate.plusMonths(1L);
        } while (!trainDate.isAfter(startDate) || trainDate.getMonthValue() % 2 != 0);
        return trainDate;
    }

    private void addTrainDate(Map<String, LocalDate> releaseDates, String milestone, Month month) {
        LocalDate releaseDate = SpringReleaseTrain.calculateReleaseDate(this.releaseTrainSpec.getYear(), month, this.releaseTrainSpec.getDayOfWeek().getDayOfWeek(), this.releaseTrainSpec.getWeekOfMonth().getDayOffset());
        Object suffix = milestone != null ? "-" + milestone : "";
        releaseDates.put(this.releaseTrainSpec.getVersion() + (String)suffix, releaseDate);
    }

    private static LocalDate calculateReleaseDate(Year year, Month month, DayOfWeek dayOfWeek, int dayOffset) {
        TemporalAdjuster nextMonday = TemporalAdjusters.nextOrSame(DayOfWeek.MONDAY);
        TemporalAdjuster nextDayOfWeek = TemporalAdjusters.nextOrSame(dayOfWeek);
        LocalDate firstDayOfMonth = year.atMonth(month).atDay(1);
        LocalDate firstMondayOfMonth = firstDayOfMonth.with(nextMonday);
        return firstMondayOfMonth.with(nextDayOfWeek).plusDays(dayOffset);
    }
}

