/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.plugin.release;

import io.spring.gradle.plugin.core.ProjectUtils;
import io.spring.gradle.plugin.core.RegularFileUtils;
import io.spring.gradle.plugin.release.GetPreviousReleaseMilestoneTask;
import io.spring.gradle.plugin.release.SpringReleasePluginExtension;
import io.spring.release.SpringReleases;
import java.util.Objects;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class DeleteSaganReleaseTask
extends DefaultTask {
    public static final String TASK_NAME = "deleteSaganRelease";

    @Input
    public abstract Property<String> getGitHubAccessToken();

    @Input
    public abstract Property<String> getProjectName();

    @Input
    @Optional
    public abstract Property<String> getVersion();

    @TaskAction
    public void deleteRelease() {
        String version = (String)this.getVersion().getOrNull();
        if (version == null) {
            System.out.println("No version provided");
            return;
        }
        String gitHubAccessToken = (String)this.getGitHubAccessToken().get();
        String projectName = (String)this.getProjectName().get();
        SpringReleases springReleases = new SpringReleases(gitHubAccessToken);
        springReleases.deleteRelease(projectName, version);
    }

    public static void register(Project project) {
        SpringReleasePluginExtension springRelease = (SpringReleasePluginExtension)project.getExtensions().findByType(SpringReleasePluginExtension.class);
        Objects.requireNonNull(springRelease, "Cannot find " + String.valueOf(SpringReleasePluginExtension.class));
        project.getTasks().register(TASK_NAME, DeleteSaganReleaseTask.class, task -> {
            task.setGroup("Release");
            task.setDescription("Delete a version for the specified project on spring.io.");
            task.doNotTrackState("API call to api.spring.io needs to check for releases every time");
            Provider versionProvider = ProjectUtils.getProperty(project, "previousVersion").orElse(ProjectUtils.findTaskByType(project, GetPreviousReleaseMilestoneTask.class).getPreviousReleaseMilestoneFile().map(RegularFileUtils::readString));
            String name = (String)springRelease.getRepositoryName().get();
            task.getGitHubAccessToken().set(ProjectUtils.getProperty(project, "gitHubAccessToken"));
            task.getProjectName().set((Object)name);
            task.getVersion().set(versionProvider);
        });
    }
}

