/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.plugin.release;

import com.github.api.Repository;
import io.spring.gradle.plugin.core.ProjectUtils;
import io.spring.gradle.plugin.core.RegularFileUtils;
import io.spring.gradle.plugin.release.GetNextReleaseMilestoneTask;
import io.spring.gradle.plugin.release.SpringReleasePluginExtension;
import io.spring.release.SpringReleases;
import java.util.Objects;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class CheckMilestoneIsDueTodayTask
extends DefaultTask {
    public static final String TASK_NAME = "checkMilestoneIsDueToday";

    @Input
    public abstract Property<Repository> getRepository();

    @Input
    public abstract Property<String> getVersion();

    @Input
    @Optional
    public abstract Property<String> getGitHubAccessToken();

    @TaskAction
    public void checkMilestoneIsDueToday() {
        String gitHubAccessToken = (String)this.getGitHubAccessToken().getOrNull();
        Repository repository = (Repository)this.getRepository().get();
        String version = (String)this.getVersion().get();
        SpringReleases springReleases = new SpringReleases(gitHubAccessToken);
        boolean milestoneDueToday = springReleases.isDueToday(repository.owner(), repository.name(), version);
        System.out.println(milestoneDueToday);
    }

    public static void register(Project project) {
        SpringReleasePluginExtension springRelease = (SpringReleasePluginExtension)project.getExtensions().findByType(SpringReleasePluginExtension.class);
        Objects.requireNonNull(springRelease, "Cannot find " + SpringReleasePluginExtension.class);
        project.getTasks().register(TASK_NAME, CheckMilestoneIsDueTodayTask.class, task -> {
            task.setGroup("Release");
            task.setDescription("Checks if the given version is due today or past due and outputs true or false");
            task.doNotTrackState("API call to GitHub needs to check milestone due date every time");
            Provider versionProvider = ProjectUtils.getProperty(project, "nextVersion").orElse(ProjectUtils.findTaskByType(project, GetNextReleaseMilestoneTask.class).getNextReleaseMilestoneFile().map(RegularFileUtils::readString));
            String owner = (String)springRelease.getRepositoryOwner().get();
            String name = (String)springRelease.getRepositoryName().get();
            task.getRepository().set((Object)new Repository(owner, name));
            task.getVersion().set(versionProvider);
            task.getGitHubAccessToken().set(ProjectUtils.getProperty(project, "gitHubAccessToken"));
        });
    }
}

