/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.org.eclipse.sisu.launch;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject.BindingPublisher;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject.InjectorBindings;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject.MutableBeanLocator;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.launch.BundleModule;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.launch.BundlePlan;
import io.spring.gradle.dependencymanagement.org.osgi.framework.Bundle;

public class SisuBundlePlan
implements BundlePlan {
    protected final MutableBeanLocator locator;

    public SisuBundlePlan(MutableBeanLocator locator) {
        this.locator = locator;
    }

    @Override
    public BindingPublisher prepare(Bundle bundle) {
        return this.appliesTo(bundle) ? new InjectorBindings(this.inject(this.compose(bundle))) : null;
    }

    protected boolean appliesTo(Bundle bundle) {
        if (bundle.getHeaders().get("Bundle-Blueprint") != null) {
            return false;
        }
        String imports = (String)bundle.getHeaders().get("Import-Package");
        return imports != null && (imports.contains("javax.inject") || imports.contains("com.google.inject"));
    }

    protected Injector inject(Module module) {
        return Guice.createInjector((Module[])new Module[]{module});
    }

    protected Module compose(Bundle bundle) {
        return new BundleModule(bundle, this.locator);
    }
}

