/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal;

import io.spring.gradle.dependencymanagement.internal.DependencyManagement;
import io.spring.gradle.dependencymanagement.internal.Exclusion;
import io.spring.gradle.dependencymanagement.internal.Exclusions;
import io.spring.gradle.dependencymanagement.internal.pom.Coordinates;
import io.spring.gradle.dependencymanagement.internal.pom.PomResolver;
import io.spring.gradle.dependencymanagement.internal.properties.PropertySource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyManagementContainer {
    private static final Logger logger = LoggerFactory.getLogger(DependencyManagementContainer.class);
    private final DependencyManagement globalDependencyManagement;
    private final PomResolver pomResolver;
    private final Project project;
    private final Map<Configuration, DependencyManagement> configurationDependencyManagement = new LinkedHashMap<Configuration, DependencyManagement>();

    public DependencyManagementContainer(Project project, PomResolver pomResolver) {
        this.project = project;
        this.pomResolver = pomResolver;
        this.globalDependencyManagement = new DependencyManagement(this.project, this.pomResolver);
    }

    public Project getProject() {
        return this.project;
    }

    void addImplicitManagedVersion(Configuration configuration, String group, String name, String version) {
        this.dependencyManagementForConfiguration(configuration).addImplicitManagedVersion(group, name, version);
    }

    public void addManagedVersion(Configuration configuration, String group, String name, String version, List<Exclusion> exclusions) {
        this.dependencyManagementForConfiguration(configuration).addExplicitManagedVersion(group, name, version, exclusions);
    }

    public void importBom(Configuration configuration, Coordinates coordinates, PropertySource properties) {
        this.dependencyManagementForConfiguration(configuration).importBom(coordinates, properties);
    }

    String getManagedVersion(Configuration configuration, String group, String name) {
        String version = null;
        if (configuration != null) {
            version = this.findManagedVersion(configuration, group, name);
        }
        if (version == null && (version = this.globalDependencyManagement.getManagedVersion(group, name)) != null) {
            logger.debug("Found managed version '{}' for dependency '{}:{}' in global dependency management", new Object[]{version, group, name});
        }
        return version;
    }

    private String findManagedVersion(Configuration source, String group, String name) {
        for (Configuration configuration : source.getHierarchy()) {
            String managedVersion = this.dependencyManagementForConfiguration(configuration).getManagedVersion(group, name);
            if (managedVersion == null) continue;
            logger.debug("Found managed version '{}' for dependency '{}:{}' in dependency management for configuration '{}'", new Object[]{managedVersion, group, name, configuration.getName()});
            return managedVersion;
        }
        return null;
    }

    public Exclusions getExclusions(Configuration configuration) {
        Exclusions exclusions = new Exclusions();
        if (configuration != null) {
            for (Configuration inHierarchy : configuration.getHierarchy()) {
                exclusions.addAll(this.dependencyManagementForConfiguration(inHierarchy).getExclusions());
            }
        }
        exclusions.addAll(this.globalDependencyManagement.getExclusions());
        return exclusions;
    }

    public Map<String, String> importedPropertiesForConfiguration(Configuration configuration) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(this.globalDependencyManagement.getImportedProperties());
        if (configuration != null) {
            for (Configuration inHierarchy : this.getReversedHierarchy(configuration)) {
                properties.putAll(this.dependencyManagementForConfiguration(inHierarchy).getImportedProperties());
            }
        }
        return properties;
    }

    public Map<String, String> getManagedVersionsForConfiguration(Configuration configuration) {
        return this.getManagedVersionsForConfiguration(configuration, true);
    }

    public Map<String, String> getManagedVersionsForConfiguration(Configuration configuration, boolean inherited) {
        if (inherited) {
            Map<String, String> managedVersions = this.dependencyManagementForConfiguration(null).getManagedVersions();
            if (configuration != null) {
                for (Configuration inHierarchy : this.getReversedHierarchy(configuration)) {
                    managedVersions.putAll(this.dependencyManagementForConfiguration(inHierarchy).getManagedVersions());
                }
            }
            return managedVersions;
        }
        return this.dependencyManagementForConfiguration(configuration).getManagedVersions();
    }

    private List<Configuration> getReversedHierarchy(Configuration configuration) {
        ArrayList<Configuration> hierarchy = new ArrayList<Configuration>(configuration.getHierarchy());
        Collections.reverse(hierarchy);
        return hierarchy;
    }

    private DependencyManagement dependencyManagementForConfiguration(Configuration configuration) {
        if (configuration == null) {
            return this.globalDependencyManagement;
        }
        DependencyManagement dependencyManagement = this.configurationDependencyManagement.get(configuration);
        if (dependencyManagement == null) {
            dependencyManagement = new DependencyManagement(this.project, configuration, this.pomResolver);
            this.configurationDependencyManagement.put(configuration, dependencyManagement);
        }
        return dependencyManagement;
    }

    public DependencyManagement getGlobalDependencyManagement() {
        return this.globalDependencyManagement;
    }
}

