/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api;

import io.smallrye.openapi.api.OpenApiConfig;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;

public class OpenApiConfigImpl
implements OpenApiConfig {
    private Config config;
    private String modelReader;
    private String filter;
    private Boolean scanDisable;
    private Pattern scanPackages;
    private Pattern scanClasses;
    private Pattern scanExcludePackages;
    private Pattern scanExcludeClasses;
    private Set<String> servers;
    private Boolean scanDependenciesDisable;
    private Set<String> scanDependenciesJars;
    private Boolean schemaReferencesEnable;
    private String customSchemaRegistryClass;
    private Boolean applicationPathDisable;
    private Map<String, String> schemas;

    public OpenApiConfigImpl(Config config) {
        this.config = config;
    }

    protected Config getConfig() {
        return this.config;
    }

    @Override
    public String modelReader() {
        if (this.modelReader == null) {
            this.modelReader = this.getStringConfigValue("mp.openapi.model.reader");
        }
        return this.modelReader;
    }

    @Override
    public String filter() {
        if (this.filter == null) {
            this.filter = this.getStringConfigValue("mp.openapi.filter");
        }
        return this.filter;
    }

    @Override
    public boolean scanDisable() {
        if (this.scanDisable == null) {
            this.scanDisable = this.getConfig().getOptionalValue("mp.openapi.scan.disable", Boolean.class).orElse(false);
        }
        return this.scanDisable;
    }

    @Override
    public Pattern scanPackages() {
        if (this.scanPackages == null) {
            this.scanPackages = this.patternOf("mp.openapi.scan.packages");
        }
        return this.scanPackages;
    }

    @Override
    public Pattern scanClasses() {
        if (this.scanClasses == null) {
            this.scanClasses = this.patternOf("mp.openapi.scan.classes");
        }
        return this.scanClasses;
    }

    @Override
    public Pattern scanExcludePackages() {
        if (this.scanExcludePackages == null) {
            this.scanExcludePackages = this.patternOf("mp.openapi.scan.exclude.packages");
        }
        return this.scanExcludePackages;
    }

    @Override
    public Pattern scanExcludeClasses() {
        if (this.scanExcludeClasses == null) {
            this.scanExcludeClasses = this.patternOf("mp.openapi.scan.exclude.classes");
        }
        return this.scanExcludeClasses;
    }

    @Override
    public Set<String> servers() {
        if (this.servers == null) {
            String theServers = this.getStringConfigValue("mp.openapi.servers");
            this.servers = OpenApiConfigImpl.asCsvSet(theServers);
        }
        return this.servers;
    }

    @Override
    public Set<String> pathServers(String path) {
        String pathServers = this.getStringConfigValue("mp.openapi.servers.path." + path);
        return OpenApiConfigImpl.asCsvSet(pathServers);
    }

    @Override
    public Set<String> operationServers(String operationId) {
        String opServers = this.getStringConfigValue("mp.openapi.servers.operation." + operationId);
        return OpenApiConfigImpl.asCsvSet(opServers);
    }

    @Override
    public boolean scanDependenciesDisable() {
        if (this.scanDependenciesDisable == null) {
            this.scanDependenciesDisable = this.getConfig().getOptionalValue("mp.openapi.extensions.scan-dependencies.disable", Boolean.class).orElse(false);
        }
        return this.scanDependenciesDisable;
    }

    @Override
    public Set<String> scanDependenciesJars() {
        if (this.scanDependenciesJars == null) {
            String classes = this.getStringConfigValue("mp.openapi.extensions.scan-dependencies.jars");
            this.scanDependenciesJars = OpenApiConfigImpl.asCsvSet(classes);
        }
        return this.scanDependenciesJars;
    }

    @Override
    public boolean schemaReferencesEnable() {
        if (this.schemaReferencesEnable == null) {
            this.schemaReferencesEnable = this.getConfig().getOptionalValue("mp.openapi.extensions.schema-references.enable", Boolean.class).orElse(true);
        }
        return this.schemaReferencesEnable;
    }

    @Override
    public String customSchemaRegistryClass() {
        if (this.customSchemaRegistryClass == null) {
            this.customSchemaRegistryClass = this.getStringConfigValue("mp.openapi.extensions.custom-schema-registry.class");
        }
        return this.customSchemaRegistryClass;
    }

    @Override
    public boolean applicationPathDisable() {
        if (this.applicationPathDisable == null) {
            this.applicationPathDisable = this.getConfig().getOptionalValue("mp.openapi.extensions.application-path.disable", Boolean.class).orElse(false);
        }
        return this.applicationPathDisable;
    }

    @Override
    public Map<String, String> getSchemas() {
        if (this.schemas == null) {
            this.schemas = StreamSupport.stream(this.config.getPropertyNames().spliterator(), false).filter(name -> name.startsWith("mp.openapi.schema.") || name.startsWith("MP_OPENAPI_SCHEMA_")).collect(Collectors.toMap(name -> name.substring("mp.openapi.schema.".length()), name -> (String)this.config.getValue(name, String.class)));
        }
        return this.schemas;
    }

    String getStringConfigValue(String key) {
        return this.getConfig().getOptionalValue(key, String.class).map(v -> "".equals(v.trim()) ? null : v).orElse(null);
    }

    Pattern patternOf(String key) {
        Pattern pattern;
        String configValue = this.getStringConfigValue(key);
        if (configValue != null && (configValue.startsWith("^") || configValue.endsWith("$"))) {
            pattern = Pattern.compile(configValue);
        } else {
            Set<String> literals = OpenApiConfigImpl.asCsvSet(configValue);
            if (literals.isEmpty()) {
                return Pattern.compile("", 16);
            }
            pattern = Pattern.compile("(" + literals.stream().map(Pattern::quote).collect(Collectors.joining("|")) + ")");
        }
        return pattern;
    }

    private static Set<String> asCsvSet(String items) {
        HashSet<String> rval = new HashSet<String>();
        if (items != null) {
            String[] split;
            for (String item : split = items.split(",")) {
                rval.add(item.trim());
            }
        }
        return rval;
    }
}

