/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigMappingContext;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappingObject;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import org.eclipse.microprofile.config.spi.Converter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ConfigMappingGenerator {
    static final boolean usefulDebugInfo = Boolean.parseBoolean(AccessController.doPrivileged(() -> System.getProperty("io.smallrye.config.mapper.useful-debug-info")));
    private static final String I_CLASS = Type.getInternalName(Class.class);
    private static final String I_COLLECTIONS = Type.getInternalName(Collections.class);
    private static final String I_CONFIGURATION_OBJECT = Type.getInternalName(ConfigMappingObject.class);
    private static final String I_CONVERTER = Type.getInternalName(Converter.class);
    private static final String I_MAP = Type.getInternalName(Map.class);
    private static final String I_COLLECTION = Type.getInternalName(Collection.class);
    private static final String I_LIST = Type.getInternalName(List.class);
    private static final String I_INT_FUNCTION = Type.getInternalName(IntFunction.class);
    private static final String I_MAPPING_CONTEXT = Type.getInternalName(ConfigMappingContext.class);
    private static final String I_OBJECT = Type.getInternalName(Object.class);
    private static final String I_OPTIONAL = Type.getInternalName(Optional.class);
    private static final String I_RUNTIME_EXCEPTION = Type.getInternalName(RuntimeException.class);
    private static final String I_SMALLRYE_CONFIG = Type.getInternalName(SmallRyeConfig.class);
    private static final String I_STRING_BUILDER = Type.getInternalName(StringBuilder.class);
    private static final String I_INTEGER = Type.getInternalName(Integer.class);
    private static final String I_STRING = Type.getInternalName(String.class);
    private static final int V_THIS = 0;
    private static final int V_MAPPING_CONTEXT = 1;
    private static final int V_STRING_BUILDER = 2;
    private static final int V_LENGTH = 3;

    static byte[] generate(ConfigMappingInterface mapping) {
        ClassWriter writer = new ClassWriter(3);
        Object visitor = usefulDebugInfo ? new Debugging.ClassVisitorImpl(writer) : writer;
        visitor.visit(52, 17, mapping.getClassInternalName(), null, I_OBJECT, new String[]{I_CONFIGURATION_OBJECT, Type.getInternalName(mapping.getInterfaceType())});
        visitor.visitSource(null, null);
        MethodVisitor ctor = visitor.visitMethod(1, "<init>", "(L" + I_MAPPING_CONTEXT + ";)V", null, null);
        ctor.visitParameter("context", 16);
        Label ctorStart = new Label();
        Label ctorEnd = new Label();
        ctor.visitLabel(ctorStart);
        ctor.visitVarInsn(25, 0);
        ctor.visitMethodInsn(183, I_OBJECT, "<init>", "()V", false);
        ctor.visitVarInsn(25, 1);
        ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "getStringBuilder", "()L" + I_STRING_BUILDER + ';', false);
        ctor.visitInsn(89);
        Label ctorSbStart = new Label();
        ctor.visitLabel(ctorSbStart);
        ctor.visitVarInsn(58, 2);
        ctor.visitMethodInsn(182, I_STRING_BUILDER, "length", "()I", false);
        Label ctorLenStart = new Label();
        ctor.visitLabel(ctorLenStart);
        ctor.visitVarInsn(54, 3);
        MethodVisitor fio = visitor.visitMethod(1, "fillInOptionals", "(L" + I_MAPPING_CONTEXT + ";)V", null, null);
        fio.visitParameter("context", 16);
        Label fioStart = new Label();
        Label fioEnd = new Label();
        fio.visitLabel(fioStart);
        fio.visitVarInsn(25, 1);
        fio.visitMethodInsn(182, I_MAPPING_CONTEXT, "getStringBuilder", "()L" + I_STRING_BUILDER + ';', false);
        fio.visitVarInsn(58, 2);
        ConfigMappingGenerator.addProperties((ClassVisitor)visitor, ctor, fio, new HashSet<String>(), mapping, mapping.getClassInternalName());
        fio.visitInsn(177);
        fio.visitLabel(fioEnd);
        fio.visitLocalVariable("mc", 'L' + I_MAPPING_CONTEXT + ';', null, fioStart, fioEnd, 1);
        fio.visitEnd();
        fio.visitMaxs(0, 0);
        ctor.visitInsn(177);
        ctor.visitLabel(ctorEnd);
        ctor.visitLocalVariable("mc", 'L' + I_MAPPING_CONTEXT + ';', null, ctorStart, ctorEnd, 1);
        ctor.visitLocalVariable("sb", 'L' + I_STRING_BUILDER + ';', null, ctorSbStart, ctorEnd, 2);
        ctor.visitLocalVariable("len", "I", null, ctorLenStart, ctorEnd, 3);
        ctor.visitEnd();
        ctor.visitMaxs(0, 0);
        visitor.visitEnd();
        return writer.toByteArray();
    }

    private static void addProperties(ClassVisitor cv, MethodVisitor ctor, MethodVisitor fio, Set<String> visited, ConfigMappingInterface mapping, String className) {
        for (ConfigMappingInterface.Property property : mapping.getProperties()) {
            Label _done;
            Label _continue;
            Method method = property.getMethod();
            String memberName = method.getName();
            if (!visited.add(memberName)) continue;
            String fieldType = Type.getInternalName(method.getReturnType());
            String fieldDesc = Type.getDescriptor(method.getReturnType());
            cv.visitField(2, memberName, fieldDesc, null, null);
            boolean optional = property.isOptional();
            ConfigMappingInterface.Property realProperty = optional ? property.asOptional().getNestedProperty() : property;
            if (property.isCollection() || realProperty.isCollection() && optional) {
                ctor.visitVarInsn(25, 0);
                boolean restoreLength = ConfigMappingGenerator.appendPropertyName(ctor, property);
                ctor.visitVarInsn(25, 1);
                ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "getConfig", "()L" + I_SMALLRYE_CONFIG + ';', false);
                ctor.visitVarInsn(25, 2);
                ctor.visitMethodInsn(182, I_STRING_BUILDER, "toString", "()L" + I_STRING + ';', false);
                if (realProperty.asCollection().getElement().isGroup()) {
                    ctor.visitMethodInsn(182, I_SMALLRYE_CONFIG, "getIndexedPropertiesIndexes", "(L" + I_STRING + ";)L" + I_LIST + ';', false);
                    ctor.visitVarInsn(58, 4);
                    ctor.visitLdcInsn((Object)Type.getType(realProperty.asCollection().getCollectionRawType()));
                    ctor.visitMethodInsn(184, I_MAPPING_CONTEXT, "createCollectionFactory", "(L" + I_CLASS + ";)L" + I_INT_FUNCTION + ';', false);
                    ctor.visitVarInsn(25, 4);
                    ctor.visitMethodInsn(185, I_LIST, "size", "()I", true);
                    ctor.visitMethodInsn(185, I_INT_FUNCTION, "apply", "(I)L" + I_OBJECT + ";", true);
                    ctor.visitVarInsn(58, 5);
                    ctor.visitInsn(3);
                    ctor.visitVarInsn(54, 6);
                    ctor.visitVarInsn(25, 4);
                    ctor.visitMethodInsn(185, I_LIST, "size", "()I", true);
                    ctor.visitVarInsn(54, 7);
                    Label iter = new Label();
                    ctor.visitLabel(iter);
                    ctor.visitVarInsn(21, 6);
                    ctor.visitVarInsn(21, 7);
                    Label each = new Label();
                    ctor.visitJumpInsn(162, each);
                    ctor.visitVarInsn(25, 4);
                    ctor.visitVarInsn(21, 6);
                    ctor.visitMethodInsn(185, I_LIST, "get", "(I)L" + I_OBJECT + ";", true);
                    ctor.visitTypeInsn(192, I_INTEGER);
                    ctor.visitVarInsn(58, 8);
                    ctor.visitVarInsn(25, 2);
                    ctor.visitMethodInsn(182, I_STRING_BUILDER, "length", "()I", false);
                    ctor.visitVarInsn(54, 9);
                    ctor.visitTypeInsn(187, I_STRING_BUILDER);
                    ctor.visitInsn(89);
                    ctor.visitMethodInsn(183, I_STRING_BUILDER, "<init>", "()V", false);
                    ctor.visitLdcInsn((Object)"[");
                    ctor.visitMethodInsn(182, I_STRING_BUILDER, "append", "(L" + I_STRING + ";)L" + I_STRING_BUILDER + ";", false);
                    ctor.visitVarInsn(25, 8);
                    ctor.visitMethodInsn(182, I_STRING_BUILDER, "append", "(L" + I_OBJECT + ";)L" + I_STRING_BUILDER + ";", false);
                    ctor.visitLdcInsn((Object)"]");
                    ctor.visitMethodInsn(182, I_STRING_BUILDER, "append", "(L" + I_STRING + ";)L" + I_STRING_BUILDER + ";", false);
                    ctor.visitMethodInsn(182, I_STRING_BUILDER, "toString", "()L" + I_STRING + ";", false);
                    ctor.visitVarInsn(58, 10);
                    ctor.visitVarInsn(25, 2);
                    ctor.visitVarInsn(25, 10);
                    ctor.visitMethodInsn(182, I_STRING_BUILDER, "append", "(L" + I_STRING + ";)L" + I_STRING_BUILDER + ";", false);
                    ctor.visitInsn(87);
                    ctor.visitVarInsn(25, 1);
                    ctor.visitLdcInsn((Object)Type.getType(realProperty.asCollection().getElement().asGroup().getGroupType().getInterfaceType()));
                    ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "constructGroup", "(L" + I_CLASS + ";)L" + I_OBJECT + ';', false);
                    ctor.visitVarInsn(58, 11);
                    ctor.visitVarInsn(25, 5);
                    ctor.visitTypeInsn(192, I_COLLECTION);
                    ctor.visitVarInsn(25, 11);
                    ctor.visitMethodInsn(185, I_COLLECTION, "add", "(L" + I_OBJECT + ";)Z", true);
                    ctor.visitInsn(87);
                    ctor.visitVarInsn(25, 1);
                    ctor.visitLdcInsn((Object)Type.getType(mapping.getInterfaceType()));
                    ctor.visitTypeInsn(187, I_STRING_BUILDER);
                    ctor.visitInsn(89);
                    ctor.visitMethodInsn(183, I_STRING_BUILDER, "<init>", "()V", false);
                    ctor.visitLdcInsn((Object)memberName);
                    ctor.visitMethodInsn(182, I_STRING_BUILDER, "append", "(L" + I_STRING + ";)L" + I_STRING_BUILDER + ";", false);
                    ctor.visitVarInsn(25, 10);
                    ctor.visitMethodInsn(182, I_STRING_BUILDER, "append", "(L" + I_STRING + ";)L" + I_STRING_BUILDER + ";", false);
                    ctor.visitMethodInsn(182, I_STRING_BUILDER, "toString", "()L" + I_STRING + ";", false);
                    ctor.visitVarInsn(25, 0);
                    ctor.visitVarInsn(25, 11);
                    ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "registerEnclosedField", "(L" + I_CLASS + ";L" + I_STRING + ";L" + I_OBJECT + ";L" + I_OBJECT + ";)V", false);
                    ctor.visitVarInsn(25, 2);
                    ctor.visitVarInsn(21, 9);
                    ctor.visitMethodInsn(182, I_STRING_BUILDER, "setLength", "(I)V", false);
                    ctor.visitIincInsn(6, 1);
                    ctor.visitJumpInsn(167, iter);
                    ctor.visitLabel(each);
                    if (optional) {
                        ctor.visitVarInsn(21, 7);
                        Label optionalEmpty = new Label();
                        ctor.visitJumpInsn(154, optionalEmpty);
                        ctor.visitVarInsn(25, 0);
                        ctor.visitMethodInsn(184, I_OPTIONAL, "empty", "()L" + I_OPTIONAL + ";", false);
                        ctor.visitFieldInsn(181, className, memberName, fieldDesc);
                        Label optionalOf = new Label();
                        ctor.visitJumpInsn(167, optionalOf);
                        ctor.visitLabel(optionalEmpty);
                        ctor.visitVarInsn(25, 0);
                        ctor.visitVarInsn(25, 5);
                        ctor.visitMethodInsn(184, I_OPTIONAL, "of", "(L" + I_OBJECT + ";)L" + I_OPTIONAL + ';', false);
                        ctor.visitFieldInsn(181, className, memberName, fieldDesc);
                        ctor.visitLabel(optionalOf);
                    } else {
                        ctor.visitVarInsn(25, 5);
                        ctor.visitFieldInsn(181, className, memberName, fieldDesc);
                    }
                } else if (optional) {
                    ctor.visitVarInsn(25, 1);
                    ctor.visitLdcInsn((Object)Type.getType(mapping.getInterfaceType()));
                    ctor.visitLdcInsn((Object)memberName);
                    ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "getValueConverter", "(L" + I_CLASS + ";L" + I_STRING + ";)L" + I_CONVERTER + ';', false);
                    ctor.visitLdcInsn((Object)Type.getType(realProperty.asCollection().getCollectionRawType()));
                    ctor.visitMethodInsn(184, I_MAPPING_CONTEXT, "createCollectionFactory", "(L" + I_CLASS + ";)L" + I_INT_FUNCTION + ";", false);
                    ctor.visitMethodInsn(182, I_SMALLRYE_CONFIG, "getOptionalValues", "(L" + I_STRING + ";L" + I_CONVERTER + ";L" + I_INT_FUNCTION + ";)L" + I_OPTIONAL + ';', false);
                    ctor.visitFieldInsn(181, className, memberName, fieldDesc);
                    if (restoreLength) {
                        ConfigMappingGenerator.restoreLength(ctor);
                    }
                } else {
                    ctor.visitVarInsn(25, 1);
                    ctor.visitLdcInsn((Object)Type.getType(mapping.getInterfaceType()));
                    ctor.visitLdcInsn((Object)memberName);
                    ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "getValueConverter", "(L" + I_CLASS + ";L" + I_STRING + ";)L" + I_CONVERTER + ';', false);
                    ctor.visitLdcInsn((Object)Type.getType((String)fieldDesc));
                    ctor.visitMethodInsn(184, I_MAPPING_CONTEXT, "createCollectionFactory", "(L" + I_CLASS + ";)L" + I_INT_FUNCTION + ";", false);
                    ctor.visitMethodInsn(182, I_SMALLRYE_CONFIG, "getValues", "(L" + I_STRING + ";L" + I_CONVERTER + ";L" + I_INT_FUNCTION + ";)L" + I_COLLECTION + ';', false);
                    ctor.visitFieldInsn(181, className, memberName, fieldDesc);
                }
                if (restoreLength) {
                    ConfigMappingGenerator.restoreLength(ctor);
                }
            } else if (property.isMap()) {
                ctor.visitMethodInsn(184, I_COLLECTIONS, "emptyMap", "()L" + I_MAP + ';', false);
                ctor.visitVarInsn(25, 0);
                ctor.visitInsn(95);
                ctor.visitFieldInsn(181, className, memberName, fieldDesc);
                fio.visitVarInsn(25, 1);
                fio.visitLdcInsn((Object)Type.getType(mapping.getInterfaceType()));
                fio.visitLdcInsn((Object)memberName);
                fio.visitVarInsn(25, 0);
                fio.visitMethodInsn(182, I_MAPPING_CONTEXT, "getEnclosedField", "(L" + I_CLASS + ";L" + I_STRING + ";L" + I_OBJECT + ";)L" + I_OBJECT + ';', false);
                fio.visitInsn(89);
                _continue = new Label();
                _done = new Label();
                fio.visitJumpInsn(198, _continue);
                fio.visitTypeInsn(192, I_MAP);
                fio.visitVarInsn(25, 0);
                fio.visitInsn(95);
                fio.visitFieldInsn(181, className, memberName, fieldDesc);
                fio.visitJumpInsn(167, _done);
                fio.visitLabel(_continue);
                fio.visitInsn(87);
                fio.visitLabel(_done);
            } else if (property.isGroup()) {
                boolean restoreLength = ConfigMappingGenerator.appendPropertyName(ctor, property);
                ctor.visitVarInsn(25, 1);
                ctor.visitLdcInsn((Object)Type.getType(realProperty.asGroup().getGroupType().getInterfaceType()));
                ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "constructGroup", "(L" + I_CLASS + ";)L" + I_OBJECT + ';', false);
                ctor.visitVarInsn(25, 0);
                ctor.visitInsn(95);
                ctor.visitFieldInsn(181, className, memberName, fieldDesc);
                ctor.visitVarInsn(25, 1);
                ctor.visitLdcInsn((Object)Type.getType(mapping.getInterfaceType()));
                ctor.visitLdcInsn((Object)memberName);
                ctor.visitVarInsn(25, 0);
                ctor.visitVarInsn(25, 0);
                ctor.visitFieldInsn(180, className, memberName, fieldDesc);
                ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "registerEnclosedField", "(L" + I_CLASS + ";L" + I_STRING + ";L" + I_OBJECT + ";L" + I_OBJECT + ";)V", false);
                if (restoreLength) {
                    ConfigMappingGenerator.restoreLength(ctor);
                }
            } else if (property.isLeaf() || property.isPrimitive() || property.isOptional() && property.isLeaf()) {
                ctor.visitVarInsn(25, 0);
                boolean restoreLength = ConfigMappingGenerator.appendPropertyName(ctor, property);
                ctor.visitVarInsn(25, 1);
                ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "getConfig", "()L" + I_SMALLRYE_CONFIG + ';', false);
                ctor.visitVarInsn(25, 2);
                ctor.visitMethodInsn(182, I_STRING_BUILDER, "toString", "()L" + I_STRING + ';', false);
                ctor.visitVarInsn(25, 1);
                ctor.visitLdcInsn((Object)Type.getType(mapping.getInterfaceType()));
                ctor.visitLdcInsn((Object)memberName);
                ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "getValueConverter", "(L" + I_CLASS + ";L" + I_STRING + ";)L" + I_CONVERTER + ';', false);
                Label _try = new Label();
                Label _catch = new Label();
                Label _continue2 = new Label();
                ctor.visitLabel(_try);
                if (property.isOptional()) {
                    ctor.visitMethodInsn(182, I_SMALLRYE_CONFIG, "getOptionalValue", "(L" + I_STRING + ";L" + I_CONVERTER + ";)L" + I_OPTIONAL + ';', false);
                } else {
                    ctor.visitMethodInsn(182, I_SMALLRYE_CONFIG, "getValue", "(L" + I_STRING + ";L" + I_CONVERTER + ";)L" + I_OBJECT + ';', false);
                }
                if (property.isPrimitive()) {
                    ConfigMappingInterface.PrimitiveProperty prim = property.asPrimitive();
                    String boxType = Type.getInternalName(prim.getBoxType());
                    ctor.visitTypeInsn(192, boxType);
                    ctor.visitMethodInsn(182, boxType, prim.getUnboxMethodName(), prim.getUnboxMethodDescriptor(), false);
                } else if (!property.isOptional()) {
                    assert (property.isLeaf());
                    ctor.visitTypeInsn(192, fieldType);
                }
                ctor.visitFieldInsn(181, className, memberName, fieldDesc);
                ctor.visitJumpInsn(167, _continue2);
                ctor.visitLabel(_catch);
                ctor.visitVarInsn(25, 1);
                ctor.visitInsn(95);
                ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "reportProblem", "(L" + I_RUNTIME_EXCEPTION + ";)V", false);
                ctor.visitLabel(_continue2);
                if (restoreLength) {
                    ConfigMappingGenerator.restoreLength(ctor);
                }
                ctor.visitTryCatchBlock(_try, _catch, _catch, I_RUNTIME_EXCEPTION);
            } else if (property.isOptional()) {
                ctor.visitMethodInsn(184, I_OPTIONAL, "empty", "()L" + I_OPTIONAL + ";", false);
                ctor.visitVarInsn(25, 0);
                ctor.visitInsn(95);
                ctor.visitFieldInsn(181, className, memberName, fieldDesc);
                fio.visitVarInsn(25, 1);
                fio.visitLdcInsn((Object)Type.getType(mapping.getInterfaceType()));
                fio.visitLdcInsn((Object)memberName);
                fio.visitVarInsn(25, 0);
                fio.visitMethodInsn(182, I_MAPPING_CONTEXT, "getEnclosedField", "(L" + I_CLASS + ";L" + I_STRING + ";L" + I_OBJECT + ";)L" + I_OBJECT + ';', false);
                fio.visitInsn(89);
                _continue = new Label();
                _done = new Label();
                fio.visitJumpInsn(198, _continue);
                fio.visitMethodInsn(184, I_OPTIONAL, "of", "(L" + I_OBJECT + ";)L" + I_OPTIONAL + ';', false);
                fio.visitVarInsn(25, 0);
                fio.visitInsn(95);
                fio.visitFieldInsn(181, className, memberName, fieldDesc);
                fio.visitJumpInsn(167, _done);
                fio.visitLabel(_continue);
                fio.visitInsn(87);
                fio.visitLabel(_done);
            }
            MethodVisitor mv = cv.visitMethod(1, memberName, "()" + fieldDesc, null, null);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, memberName, fieldDesc);
            if (property.isPrimitive()) {
                mv.visitInsn(ConfigMappingGenerator.getReturnInstruction(property.asPrimitive()));
            } else {
                mv.visitInsn(176);
            }
            mv.visitEnd();
            mv.visitMaxs(0, 0);
        }
        for (ConfigMappingInterface superType : mapping.getSuperTypes()) {
            ConfigMappingGenerator.addProperties(cv, ctor, fio, visited, superType, className);
        }
    }

    private static boolean appendPropertyName(MethodVisitor ctor, ConfigMappingInterface.Property property) {
        if (property.isParentPropertyName()) {
            return false;
        }
        Label _continue = new Label();
        ctor.visitVarInsn(25, 2);
        ctor.visitMethodInsn(182, I_STRING_BUILDER, "length", "()I", false);
        ctor.visitJumpInsn(153, _continue);
        ctor.visitVarInsn(25, 2);
        ctor.visitLdcInsn((Object)Character.valueOf('.'));
        ctor.visitInsn(146);
        ctor.visitMethodInsn(182, I_STRING_BUILDER, "append", "(C)L" + I_STRING_BUILDER + ';', false);
        ctor.visitInsn(87);
        ctor.visitLabel(_continue);
        ctor.visitVarInsn(25, 2);
        ctor.visitVarInsn(25, 1);
        ctor.visitLdcInsn((Object)property.getPropertyName());
        ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "applyNamingStrategy", "(L" + I_STRING + ";)L" + I_STRING + ";", false);
        ctor.visitMethodInsn(182, I_STRING_BUILDER, "append", "(L" + I_STRING + ";)L" + I_STRING_BUILDER + ';', false);
        ctor.visitInsn(87);
        return true;
    }

    private static void restoreLength(MethodVisitor ctor) {
        ctor.visitVarInsn(25, 2);
        ctor.visitVarInsn(21, 3);
        ctor.visitMethodInsn(182, I_STRING_BUILDER, "setLength", "(I)V", false);
    }

    private static int getReturnInstruction(ConfigMappingInterface.PrimitiveProperty primitiveProperty) {
        if (primitiveProperty.getPrimitiveType() == Float.TYPE) {
            return 174;
        }
        if (primitiveProperty.getPrimitiveType() == Double.TYPE) {
            return 175;
        }
        if (primitiveProperty.getPrimitiveType() == Long.TYPE) {
            return 173;
        }
        return 172;
    }

    static final class Debugging {
        Debugging() {
        }

        static StackTraceElement getCaller() {
            return new Throwable().getStackTrace()[2];
        }

        static final class ClassVisitorImpl
        extends ClassVisitor {
            final String sourceFile = Debugging.getCaller().getFileName();

            ClassVisitorImpl(int api) {
                super(api);
            }

            ClassVisitorImpl(ClassWriter cw) {
                super(458752, (ClassVisitor)cw);
            }

            public void visitSource(String source, String debug) {
                super.visitSource(this.sourceFile, debug);
            }

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                return new MethodVisitorImpl(this.api, super.visitMethod(access, name, descriptor, signature, exceptions));
            }
        }

        static final class MethodVisitorImpl
        extends MethodVisitor {
            MethodVisitorImpl(int api) {
                super(api);
            }

            MethodVisitorImpl(int api, MethodVisitor methodVisitor) {
                super(api, methodVisitor);
            }

            public void visitInsn(int opcode) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitInsn(opcode);
            }

            public void visitIntInsn(int opcode, int operand) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitIntInsn(opcode, operand);
            }

            public void visitVarInsn(int opcode, int var) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitVarInsn(opcode, var);
            }

            public void visitTypeInsn(int opcode, String type) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitTypeInsn(opcode, type);
            }

            public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitFieldInsn(opcode, owner, name, descriptor);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String descriptor) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitMethodInsn(opcode, owner, name, descriptor);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            }

            public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
            }

            public void visitJumpInsn(int opcode, Label label) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitJumpInsn(opcode, label);
            }

            public void visitLdcInsn(Object value) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitLdcInsn(value);
            }

            public void visitIincInsn(int var, int increment) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitIincInsn(var, increment);
            }

            public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitTableSwitchInsn(min, max, dflt, labels);
            }

            public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitLookupSwitchInsn(dflt, keys, labels);
            }

            public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitMultiANewArrayInsn(descriptor, numDimensions);
            }
        }
    }
}

