/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.version;

import io.smallrye.common.version.BasicVersionScheme;
import io.smallrye.common.version.JpmsVersionScheme;
import io.smallrye.common.version.MavenVersionScheme;
import io.smallrye.common.version.VersionIterator;
import io.smallrye.common.version.VersionSyntaxException;
import java.util.Comparator;

public interface VersionScheme
extends Comparator<String> {
    public static final VersionScheme BASIC = new BasicVersionScheme();
    public static final VersionScheme MAVEN = new MavenVersionScheme();
    public static final VersionScheme JPMS = new JpmsVersionScheme();

    @Override
    public int compare(String var1, String var2);

    default public boolean equals(String v1, String v2) {
        return this.compare(v1, v2) == 0;
    }

    default public String canonicalize(String original) {
        return this.appendCanonicalized(new StringBuilder(original.length()), original).toString();
    }

    public StringBuilder appendCanonicalized(StringBuilder var1, String var2);

    default public void validate(String version) throws VersionSyntaxException {
        VersionIterator itr = this.iterate(version);
        while (itr.hasNext()) {
            itr.next();
        }
    }

    public VersionIterator iterate(String var1);
}

