/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.spring.commons.config;

import io.restassured.config.ParamConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.module.spring.commons.config.SpecificationConfig;
import java.lang.reflect.Field;

public final class ConfigConverter {
    private ConfigConverter() {
    }

    public static RestAssuredConfig convertToRestAssuredConfig(SpecificationConfig specificationConfig) {
        return new RestAssuredConfig().jsonConfig(specificationConfig.getJsonConfig()).xmlConfig(specificationConfig.getXmlConfig()).sessionConfig(specificationConfig.getSessionConfig()).objectMapperConfig(specificationConfig.getObjectMapperConfig()).logConfig(specificationConfig.getLogConfig()).encoderConfig(specificationConfig.getEncoderConfig()).decoderConfig(specificationConfig.getDecoderConfig()).multiPartConfig(specificationConfig.getMultiPartConfig()).paramConfig(ConfigConverter.toParamConfig(specificationConfig.getParamConfig())).matcherConfig(specificationConfig.getMatcherConfig());
    }

    private static ParamConfig toParamConfig(ParamConfig baseConfig) {
        ParamConfig config = new ParamConfig(baseConfig.queryParamsUpdateStrategy(), baseConfig.pathParamsUpdateStrategy(), baseConfig.formParamsUpdateStrategy(), baseConfig.requestParamsUpdateStrategy());
        if (!baseConfig.isUserConfigured()) {
            Field userConfigured = null;
            try {
                userConfigured = config.getClass().getDeclaredField("userConfigured");
                userConfigured.setAccessible(true);
                userConfigured.set(config, false);
            }
            catch (Exception e) {
                throw new RuntimeException("Internal error in REST Assured, please report an issue!", e);
            }
            finally {
                if (userConfigured != null) {
                    userConfigured.setAccessible(false);
                }
            }
        }
        return config;
    }
}

