/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractArrayCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import java.util.Collections;
import java.util.UUID;
import java.util.function.Supplier;

final class UuidArrayCodec
extends AbstractArrayCodec<UUID> {
    UuidArrayCodec(ByteBufAllocator byteBufAllocator) {
        super(byteBufAllocator, UUID.class);
    }

    @Override
    public Parameter encodeNull() {
        return UuidArrayCodec.createNull(PostgresqlObjectId.UUID_ARRAY, Format.FORMAT_TEXT);
    }

    @Override
    public Iterable<PostgresqlObjectId> getDataTypes() {
        return Collections.singleton(PostgresqlObjectId.UUID_ARRAY);
    }

    @Override
    UUID doDecodeBinary(ByteBuf byteBuffer) {
        return new UUID(byteBuffer.readLong(), byteBuffer.readLong());
    }

    @Override
    UUID doDecodeText(String text) {
        return UUID.fromString(text);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.UUID_ARRAY == type;
    }

    @Override
    Parameter encodeArray(Supplier<ByteBuf> encodedSupplier) {
        return UuidArrayCodec.create(PostgresqlObjectId.UUID_ARRAY, Format.FORMAT_TEXT, encodedSupplier);
    }

    @Override
    String doEncodeText(UUID value) {
        Assert.requireNonNull(value, "value must not be null");
        return value.toString();
    }
}

