/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractNumericCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import reactor.util.annotation.Nullable;

final class IntegerCodec
extends AbstractNumericCodec<Integer> {
    private final ByteBufAllocator byteBufAllocator;

    IntegerCodec(ByteBufAllocator byteBufAllocator) {
        super(Integer.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public Parameter encodeNull() {
        return IntegerCodec.createNull(PostgresqlObjectId.INT4, Format.FORMAT_BINARY);
    }

    @Override
    Integer doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, @Nullable Class<? extends Integer> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        Assert.requireNonNull(format, "format must not be null");
        return this.decodeNumber(buffer, dataType, format, Integer.class, Number::intValue);
    }

    @Override
    Parameter doEncode(Integer value) {
        Assert.requireNonNull(value, "value must not be null");
        return IntegerCodec.create(PostgresqlObjectId.INT4, Format.FORMAT_BINARY, () -> this.byteBufAllocator.buffer(4).writeInt(value.intValue()));
    }

    @Override
    PostgresqlObjectId getDefaultType() {
        return PostgresqlObjectId.INT4;
    }
}

