/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public final class Parameter {
    public static final Flux<? extends ByteBuf> NULL_VALUE = Flux.empty();
    private final Format format;
    private final int type;
    private final Publisher<? extends ByteBuf> value;

    public Parameter(Format format, int type, Publisher<? extends ByteBuf> value) {
        this.format = Assert.requireNonNull(format, "format must not be null");
        this.type = type;
        this.value = Assert.requireNonNull(value, "value must not be null");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter that = (Parameter)o;
        return this.format == that.format && Objects.equals(this.type, that.type) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.format, this.type, this.value});
    }

    public String toString() {
        return "Parameter{format=" + (Object)((Object)this.format) + ", type=" + this.type + ", value=" + this.value + '}';
    }

    Format getFormat() {
        return this.format;
    }

    int getType() {
        return this.type;
    }

    Publisher<? extends ByteBuf> getValue() {
        return this.value;
    }
}

