/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import io.r2dbc.postgresql.client.Client;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.message.frontend.CancelRequest;
import io.r2dbc.postgresql.message.frontend.FrontendMessage;
import io.r2dbc.postgresql.util.Assert;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class CancelRequestMessageFlow {
    private CancelRequestMessageFlow() {
    }

    public static Flux<BackendMessage> exchange(Client client) {
        Assert.requireNonNull(client, "client must not be null");
        int processId = client.getProcessId().orElseThrow(() -> new IllegalStateException("Connection does not yet have a processId"));
        int secretKey = client.getSecretKey().orElseThrow(() -> new IllegalStateException("Connection does not yet have a secretKey"));
        return client.exchange((Publisher<FrontendMessage>)Mono.just((Object)new CancelRequest(processId, secretKey)));
    }
}

