/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.type;

import io.r2dbc.mssql.message.type.LengthStrategy;
import io.r2dbc.mssql.message.type.TdsDataType;
import io.r2dbc.mssql.util.Assert;
import reactor.util.annotation.Nullable;

public enum SqlServerType {
    UNKNOWN(Category.UNKNOWN, "unknown"),
    TINYINT(Category.NUMERIC, "tinyint", 1, TdsDataType.INTN, TdsDataType.INT1),
    BIT(Category.NUMERIC, "bit", 1, TdsDataType.INTN, TdsDataType.INT1),
    SMALLINT(Category.NUMERIC, "smallint", 2, TdsDataType.INTN, TdsDataType.INT2),
    INTEGER(Category.NUMERIC, "int", 4, TdsDataType.INTN, TdsDataType.INT4),
    BIGINT(Category.NUMERIC, "bigint", 8, TdsDataType.INTN, TdsDataType.INT8),
    FLOAT(Category.NUMERIC, "float", 8, TdsDataType.FLOATN, TdsDataType.FLOAT8),
    REAL(Category.NUMERIC, "real", 4, TdsDataType.FLOATN, TdsDataType.FLOAT4),
    SMALLDATETIME(Category.DATETIME, "smalldatetime", 4, TdsDataType.DATETIMEN, TdsDataType.DATETIME4),
    DATETIME(Category.DATETIME, "datetime", 8, TdsDataType.DATETIMEN, TdsDataType.DATETIME8),
    DATE(Category.DATE, "date", 3, TdsDataType.DATEN, new TdsDataType[0]),
    TIME(Category.TIME, "time", 7, TdsDataType.TIMEN, new TdsDataType[0]),
    DATETIME2(Category.DATETIME2, "datetime2", 7, TdsDataType.DATETIME2N, new TdsDataType[0]),
    DATETIMEOFFSET(Category.DATETIMEOFFSET, "datetimeoffset", 7, TdsDataType.DATETIMEOFFSETN, new TdsDataType[0]),
    SMALLMONEY(Category.NUMERIC, "smallmoney", 4, TdsDataType.MONEYN, TdsDataType.MONEY4),
    MONEY(Category.NUMERIC, "money", 8, TdsDataType.MONEYN, TdsDataType.MONEY8),
    CHAR(Category.CHARACTER, "char"),
    VARCHAR(Category.CHARACTER, "varchar"),
    VARCHARMAX(Category.LONG_CHARACTER, "varchar", TdsDataType.BIGVARCHAR, new TdsDataType[0]),
    TEXT(Category.LONG_CHARACTER, "text", TdsDataType.TEXT, new TdsDataType[0]),
    NCHAR(Category.NCHARACTER, "nchar"),
    NVARCHAR(Category.NCHARACTER, "nvarchar", 4000, TdsDataType.NVARCHAR, new TdsDataType[0]),
    NVARCHARMAX(Category.LONG_NCHARACTER, "nvarchar", TdsDataType.NVARCHAR, new TdsDataType[0]),
    NTEXT(Category.LONG_NCHARACTER, "ntext", TdsDataType.NTEXT, new TdsDataType[0]),
    BINARY(Category.BINARY, "binary"),
    VARBINARY(Category.BINARY, "varbinary", 8000, TdsDataType.BIGVARBINARY, new TdsDataType[0]),
    VARBINARYMAX(Category.LONG_BINARY, "varbinary", TdsDataType.BIGVARBINARY, new TdsDataType[0]),
    IMAGE(Category.LONG_BINARY, "image", TdsDataType.IMAGE, new TdsDataType[0]),
    DECIMAL(Category.NUMERIC, "decimal", 38, TdsDataType.DECIMALN, new TdsDataType[0]),
    NUMERIC(Category.NUMERIC, "numeric", 38, TdsDataType.NUMERICN, new TdsDataType[0]),
    GUID(Category.GUID, "uniqueidentifier", 16, TdsDataType.GUID, new TdsDataType[0]),
    SQL_VARIANT(Category.SQL_VARIANT, "sql_variant", TdsDataType.SQL_VARIANT, new TdsDataType[0]),
    UDT(Category.UDT, "udt"),
    XML(Category.XML, "xml"),
    TIMESTAMP(Category.TIMESTAMP, "timestamp", 8, TdsDataType.BIGBINARY, new TdsDataType[0]),
    GEOMETRY(Category.UDT, "geometry"),
    GEOGRAPHY(Category.UDT, "geography");

    private final Category category;
    private final String name;
    private final int maxLength;
    @Nullable
    private final TdsDataType nullableType;
    private final TdsDataType[] fixedTypes;

    private SqlServerType(Category category, String name, TdsDataType nullableType, TdsDataType ... fixedTypes) {
        this(category, name, 0, nullableType, fixedTypes);
    }

    private SqlServerType(Category category, String name, int maxLength, TdsDataType nullableType, TdsDataType ... fixedTypes) {
        Assert.isTrue(nullableType.getLengthStrategy() != LengthStrategy.FIXEDLENTYPE, String.format("Type [%s] specified a fixed-length strategy in its nullable type", name));
        for (TdsDataType fixedType : fixedTypes) {
            Assert.isTrue(fixedType.getLengthStrategy() == LengthStrategy.FIXEDLENTYPE, String.format("Type [%s] specified [%s] in its fixed length type [%s] ", new Object[]{name, fixedType.getLengthStrategy(), fixedType}));
        }
        this.category = category;
        this.name = name;
        this.maxLength = maxLength;
        this.nullableType = nullableType;
        this.fixedTypes = fixedTypes;
    }

    private SqlServerType(Category category, String name) {
        this.category = category;
        this.name = name;
        this.maxLength = 0;
        this.nullableType = null;
        this.fixedTypes = new TdsDataType[0];
    }

    static SqlServerType of(String typeName) {
        for (SqlServerType type : SqlServerType.values()) {
            if (!type.name.equalsIgnoreCase(typeName)) continue;
            return type;
        }
        throw new IllegalArgumentException(String.format("Unknown type: %s", typeName));
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    @Nullable
    public TdsDataType getNullableType() {
        return this.nullableType;
    }

    public TdsDataType[] getFixedTypes() {
        return this.fixedTypes;
    }

    public String toString() {
        return this.name;
    }

    static enum Category {
        BINARY,
        CHARACTER,
        DATE,
        DATETIME,
        DATETIME2,
        DATETIMEOFFSET,
        GUID,
        LONG_BINARY,
        LONG_CHARACTER,
        LONG_NCHARACTER,
        NCHARACTER,
        NUMERIC,
        UNKNOWN,
        TIME,
        TIMESTAMP,
        UDT,
        SQL_VARIANT,
        XML;

    }
}

