/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.MssqlRowMetadata;
import io.r2dbc.mssql.codec.Codecs;
import io.r2dbc.mssql.message.token.Column;
import io.r2dbc.mssql.message.token.RowToken;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.Row;
import reactor.util.annotation.Nullable;

final class MssqlRow
implements Row {
    private static final int STATE_ACTIVE = 0;
    private static final int STATE_RELEASED = 1;
    private final Codecs codecs;
    private final MssqlRowMetadata metadata;
    private final RowToken rowToken;
    private volatile int state = 0;

    MssqlRow(Codecs codecs, RowToken rowToken, MssqlRowMetadata metadata) {
        this.codecs = codecs;
        this.metadata = metadata;
        this.rowToken = rowToken;
    }

    static MssqlRow toRow(Codecs codecs, RowToken rowToken, MssqlRowMetadata metadata) {
        Assert.requireNonNull(codecs, "Codecs must not be null");
        Assert.requireNonNull(rowToken, "RowToken must not be null");
        Assert.requireNonNull(metadata, "MssqlRowMetadata must not be null");
        return new MssqlRow(codecs, rowToken, metadata);
    }

    public MssqlRowMetadata getMetadata() {
        return this.metadata;
    }

    public <T> T get(int index, Class<T> type) {
        Assert.requireNonNull(type, "Type must not be null");
        this.requireNotReleased();
        Column column = this.metadata.getColumn(index);
        return this.doGet(column, type);
    }

    public <T> T get(String name, Class<T> type) {
        Assert.requireNonNull(name, "Name must not be null");
        Assert.requireNonNull(type, "Type must not be null");
        this.requireNotReleased();
        Column column = this.metadata.getColumn(name);
        return this.doGet(column, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T> T doGet(Column column, Class<T> type) {
        ByteBuf columnData = this.rowToken.getColumnData(column.getIndex());
        if (columnData == null) {
            return null;
        }
        if (column.getType().getServerType() == SqlServerType.SQL_VARIANT) {
            throw new UnsupportedOperationException("sql_variant columns not supported. See https://github.com/r2dbc/r2dbc-mssql/issues/67.");
        }
        columnData.markReaderIndex();
        try {
            T t = this.codecs.decode(columnData, column, type);
            return t;
        }
        finally {
            columnData.resetReaderIndex();
        }
    }

    public void release() {
        this.requireNotReleased();
        this.state = 1;
        this.rowToken.release();
    }

    private void requireNotReleased() {
        if (this.state == 1) {
            throw new IllegalStateException("Value cannot be retrieved after row has been released");
        }
    }
}

