/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.Operators;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.context.Context;

class FluxDiscardOnCancel<T>
extends FluxOperator<T, T> {
    private static final Logger logger = Loggers.getLogger(FluxDiscardOnCancel.class);
    private final Runnable cancelConsumer;

    FluxDiscardOnCancel(Flux<? extends T> source, Runnable cancelConsumer) {
        super(source);
        this.cancelConsumer = cancelConsumer;
    }

    public void subscribe(CoreSubscriber<? super T> actual) {
        this.source.subscribe(new FluxDiscardOnCancelSubscriber<T>(actual, this.cancelConsumer));
    }

    static class FluxDiscardOnCancelSubscriber<T>
    extends AtomicBoolean
    implements CoreSubscriber<T>,
    Subscription {
        final CoreSubscriber<T> actual;
        final Context ctx;
        final Runnable cancelConsumer;
        Subscription s;

        FluxDiscardOnCancelSubscriber(CoreSubscriber<T> actual, Runnable cancelConsumer) {
            this.actual = actual;
            this.ctx = actual.currentContext();
            this.cancelConsumer = cancelConsumer;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.get()) {
                Operators.onDiscard(t, (Context)this.ctx);
                return;
            }
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            if (this.get()) {
                Operators.onErrorDropped((Throwable)t, (Context)this.ctx);
            } else {
                this.actual.onError(t);
            }
        }

        public void onComplete() {
            if (!this.get()) {
                this.actual.onComplete();
            }
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            if (this.compareAndSet(false, true)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("received cancel signal");
                }
                try {
                    this.cancelConsumer.run();
                }
                catch (Exception e) {
                    Operators.onErrorDropped((Throwable)e, (Context)this.ctx);
                }
                this.s.request(Long.MAX_VALUE);
            }
        }
    }
}

