/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.spi.runtime.AuthorizationController;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.vertx.http.runtime.security.AbstractHttpAuthorizer;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class HttpAuthorizer
extends AbstractHttpAuthorizer {
    HttpAuthorizer(HttpAuthenticator httpAuthenticator, IdentityProviderManager identityProviderManager, AuthorizationController controller, Instance<HttpSecurityPolicy> installedPolicies, BlockingSecurityExecutor blockingExecutor) {
        super(httpAuthenticator, identityProviderManager, controller, HttpAuthorizer.toList(installedPolicies), blockingExecutor);
    }

    private static List<HttpSecurityPolicy> toList(Instance<HttpSecurityPolicy> installedPolicies) {
        ArrayList<HttpSecurityPolicy> globalPolicies = new ArrayList<HttpSecurityPolicy>();
        for (HttpSecurityPolicy i : installedPolicies) {
            if (i.name() != null) continue;
            globalPolicies.add(i);
        }
        return globalPolicies;
    }
}

