/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.kubernetes.client;

import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.server.mock.KubernetesMixedDispatcher;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServer;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.MockWebServer;
import io.fabric8.mockwebserver.dsl.MockServerExpectation;
import io.fabric8.mockwebserver.http.Dispatcher;
import io.fabric8.mockwebserver.http.RecordedRequest;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;

public class KubernetesServer {
    private KubernetesMockServer kubernetesMockServer;
    private NamespacedKubernetesClient client;
    private final boolean https;
    private final boolean crudMode;
    private final InetAddress address;
    private final int port;
    private final List<CustomResourceDefinitionContext> crdContextList;

    public KubernetesServer(boolean https, boolean crudMode, InetAddress address, int port, List<CustomResourceDefinitionContext> crdContextList) {
        this.https = https;
        this.crudMode = crudMode;
        this.address = address;
        this.port = port;
        this.crdContextList = crdContextList;
    }

    public final void before() {
        HashMap responses = new HashMap();
        this.kubernetesMockServer = this.crudMode ? new KubernetesMockServer(new Context(), new MockWebServer(), responses, (Dispatcher)new KubernetesMixedDispatcher(responses, this.crdContextList), this.https) : new KubernetesMockServer(this.https);
        this.kubernetesMockServer.init(this.address, this.port);
        this.client = this.kubernetesMockServer.createClient();
    }

    public final void after() {
        this.kubernetesMockServer.destroy();
        this.client.close();
    }

    public final NamespacedKubernetesClient getClient() {
        return this.client;
    }

    public final MockServerExpectation expect() {
        return this.kubernetesMockServer.expect();
    }

    public final KubernetesMockServer getKubernetesMockServer() {
        return this.kubernetesMockServer;
    }

    public final RecordedRequest getLastRequest() throws InterruptedException {
        return this.kubernetesMockServer.getLastRequest();
    }
}

