/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.runtime.configuration.QuarkusConfigFactory;
import io.smallrye.config.SmallRyeConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.Config;

public final class TestConfigUtil {
    public static final long DEFAULT_WAIT_TIME_SECONDS = 60L;

    private TestConfigUtil() {
    }

    public static List<String> argLineValues(String argLine) {
        if (argLine == null || argLine.isBlank()) {
            return List.of();
        }
        String[] parts = argLine.split("\\s+");
        ArrayList<String> result = new ArrayList<String>(parts.length);
        for (String s : parts) {
            String trimmed = s.trim();
            if (trimmed.isEmpty()) continue;
            result.add(trimmed);
        }
        return result;
    }

    @Deprecated(forRemoval=true, since="3.17")
    public static List<String> argLineValue(Config config) {
        String strValue = config.getOptionalValue("quarkus.test.arg-line", String.class).orElse(config.getOptionalValue("quarkus.test.argLine", String.class).orElse(null));
        if (strValue == null) {
            return Collections.emptyList();
        }
        String[] parts = strValue.split("\\s+");
        ArrayList<String> result = new ArrayList<String>(parts.length);
        for (String s : parts) {
            String trimmed = s.trim();
            if (trimmed.isEmpty()) continue;
            result.add(trimmed);
        }
        return result;
    }

    @Deprecated(forRemoval=true, since="3.17")
    public static Map<String, String> env(Config config) {
        return ((SmallRyeConfig)config).getOptionalValues("quarkus.test.env", String.class, String.class).orElse(Collections.emptyMap());
    }

    @Deprecated(forRemoval=true, since="3.17")
    public static Duration waitTimeValue(Config config) {
        return config.getOptionalValue("quarkus.test.wait-time", Duration.class).orElseGet(() -> config.getOptionalValue("quarkus.test.jar-wait-time", Duration.class).orElseGet(() -> Duration.ofSeconds(60L)));
    }

    @Deprecated(forRemoval=true, since="3.17")
    public static String integrationTestProfile(Config config) {
        return config.getOptionalValue("quarkus.test.integration-test-profile", String.class).orElseGet(() -> config.getOptionalValue("quarkus.test.native-image-profile", String.class).orElse(null));
    }

    public static String runTarget(Config config) {
        return config.getOptionalValue("quarkus.run.target", String.class).orElse(null);
    }

    public static void cleanUp() {
        try {
            QuarkusConfigFactory.setConfig(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

