/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.db.token.state.manager.runtime;

import io.quarkus.oidc.AuthorizationCodeTokens;
import io.quarkus.oidc.OidcRequestContext;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TokenStateManager;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.AuthenticationFailedException;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.Tuple;
import java.time.Instant;
import java.util.UUID;
import java.util.function.Function;
import org.jboss.logging.Logger;

public class OidcDbTokenStateManager
implements TokenStateManager {
    private static final Logger LOG = Logger.getLogger(OidcDbTokenStateManager.class);
    private static final String TOKEN_STATE_INSERT_FAILED = "Failed to insert token state into database";
    private static final String FAILED_TO_ACQUIRE_TOKEN = "Failed to acquire authorization code tokens";
    private final String insertStatement;
    private final String deleteStatement;
    private final String getQuery;
    private Pool pool;

    OidcDbTokenStateManager(String insertStatement, String deleteStatement, String getQuery) {
        this.insertStatement = insertStatement;
        this.deleteStatement = deleteStatement;
        this.getQuery = getQuery;
    }

    void setSqlClientPool(Pool pool) {
        this.pool = pool;
    }

    public Uni<String> createTokenState(RoutingContext event, OidcTenantConfig oidcConfig, AuthorizationCodeTokens tokens, OidcRequestContext<String> requestContext) {
        final String id = OidcDbTokenStateManager.now() + UUID.randomUUID().toString();
        return Uni.createFrom().completionStage(this.pool.withTransaction(client -> client.preparedQuery(this.insertStatement).execute(Tuple.of((Object)tokens.getIdToken(), (Object)tokens.getAccessToken(), (Object)tokens.getRefreshToken(), (Object)OidcDbTokenStateManager.expiresIn(event), (Object)id))).toCompletionStage()).onFailure().transform((Function)new Function<Throwable, Throwable>(){

            @Override
            public Throwable apply(Throwable throwable) {
                return new AuthenticationFailedException(OidcDbTokenStateManager.TOKEN_STATE_INSERT_FAILED, throwable);
            }
        }).flatMap((Function)new Function<RowSet<Row>, Uni<? extends String>>(){

            @Override
            public Uni<? extends String> apply(RowSet<Row> rows) {
                if (rows != null) {
                    return Uni.createFrom().item((Object)id);
                }
                return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(OidcDbTokenStateManager.TOKEN_STATE_INSERT_FAILED));
            }
        }).memoize().indefinitely();
    }

    public Uni<AuthorizationCodeTokens> getTokens(RoutingContext routingContext, OidcTenantConfig oidcConfig, String tokenState, OidcRequestContext<AuthorizationCodeTokens> requestContext) {
        return Uni.createFrom().completionStage(this.pool.preparedQuery(this.getQuery).execute(Tuple.of((Object)tokenState)).toCompletionStage()).onFailure().transform((Function)new Function<Throwable, Throwable>(){

            @Override
            public Throwable apply(Throwable throwable) {
                return new AuthenticationCompletionException(OidcDbTokenStateManager.FAILED_TO_ACQUIRE_TOKEN, throwable);
            }
        }).flatMap((Function)new Function<RowSet<Row>, Uni<? extends AuthorizationCodeTokens>>(){

            @Override
            public Uni<? extends AuthorizationCodeTokens> apply(RowSet<Row> rows) {
                RowIterator iterator;
                if (rows != null && (iterator = rows.iterator()).hasNext()) {
                    Row firstRow = (Row)iterator.next();
                    return Uni.createFrom().item((Object)new AuthorizationCodeTokens(firstRow.getString("id_token"), firstRow.getString("access_token"), firstRow.getString("refresh_token")));
                }
                return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException(OidcDbTokenStateManager.FAILED_TO_ACQUIRE_TOKEN));
            }
        }).memoize().indefinitely();
    }

    public Uni<Void> deleteTokens(RoutingContext routingContext, OidcTenantConfig oidcConfig, String tokenState, OidcRequestContext<Void> requestContext) {
        return Uni.createFrom().completionStage(this.pool.preparedQuery(this.deleteStatement).execute(Tuple.of((Object)tokenState)).toCompletionStage()).replaceWithVoid().onFailure().recoverWithItem((Function)new Function<Throwable, Void>(){

            @Override
            public Void apply(Throwable throwable) {
                LOG.debugf("Failed to delete tokens: %s", (Object)throwable.getMessage());
                return null;
            }
        });
    }

    static long now() {
        return Instant.now().getEpochSecond();
    }

    private static long expiresIn(RoutingContext event) {
        return OidcDbTokenStateManager.now() + (Long)event.get("session-max-age");
    }
}

