/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gcp.functions;

import com.fasterxml.jackson.core.JsonParseException;
import com.google.cloud.functions.BackgroundFunction;
import com.google.cloud.functions.Context;
import com.google.cloud.functions.RawBackgroundFunction;
import com.google.gson.Gson;
import io.quarkus.arc.Arc;
import io.quarkus.runtime.Application;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public final class QuarkusBackgroundFunction
implements RawBackgroundFunction {
    protected static final String deploymentStatus;
    protected static boolean started;
    private static volatile BackgroundFunction delegate;
    private static volatile Class<?> parameterType;
    private static volatile RawBackgroundFunction rawDelegate;

    static void setDelegates(String selectedDelegate, String selectedRawDelegate) {
        Class<?> clazz;
        if (selectedDelegate != null) {
            try {
                clazz = Class.forName(selectedDelegate, false, Thread.currentThread().getContextClassLoader());
                for (Method method : clazz.getDeclaredMethods()) {
                    Class<?>[] parameterTypes;
                    if (!method.getName().equals("accept") || (parameterTypes = method.getParameterTypes())[0] == Object.class) continue;
                    parameterType = parameterTypes[0];
                }
                delegate = (BackgroundFunction)Arc.container().instance(clazz, new Annotation[0]).get();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (selectedRawDelegate != null) {
            try {
                clazz = Class.forName(selectedRawDelegate, false, Thread.currentThread().getContextClassLoader());
                rawDelegate = (RawBackgroundFunction)Arc.container().instance(clazz, new Annotation[0]).get();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void accept(String event, Context context) throws Exception {
        if (!started) {
            throw new IOException(deploymentStatus);
        }
        if (delegate == null && rawDelegate == null || delegate != null && rawDelegate != null) {
            throw new IOException("We didn't found any BackgroundFunction or RawBackgroundFunction to run (or there is multiple one and none selected inside your application.properties)");
        }
        if (rawDelegate != null) {
            rawDelegate.accept(event, context);
        } else {
            Gson gson = new Gson();
            try {
                Object eventObj = gson.fromJson(event, parameterType);
                delegate.accept(eventObj, context);
            }
            catch (JsonParseException e) {
                throw new RuntimeException("Could not parse received event payload into type " + parameterType.getCanonicalName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        started = false;
        StringWriter error = new StringWriter();
        PrintWriter errorWriter = new PrintWriter((Writer)error, true);
        if (Application.currentApplication() == null) {
            ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(QuarkusBackgroundFunction.class.getClassLoader());
                Class<?> appClass = Class.forName("io.quarkus.runner.ApplicationImpl");
                String[] args = new String[]{};
                Application app = (Application)appClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                app.start(args);
                errorWriter.println("Quarkus bootstrapped successfully.");
                started = true;
            }
            catch (Exception ex) {
                errorWriter.println("Quarkus bootstrap failed.");
                ex.printStackTrace(errorWriter);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentCl);
            }
        } else {
            errorWriter.println("Quarkus bootstrapped successfully.");
            started = true;
        }
        deploymentStatus = error.toString();
    }
}

