/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.quarkus.registry.catalog.PlatformRelease;
import io.quarkus.registry.catalog.PlatformReleaseVersion;
import io.quarkus.registry.catalog.PlatformStreamImpl;
import io.quarkus.registry.json.JsonBuilder;
import java.util.Collection;
import java.util.Map;

public interface PlatformStream {
    public String getId();

    public String getName();

    public Collection<PlatformRelease> getReleases();

    public Map<String, Object> getMetadata();

    public PlatformRelease getRelease(PlatformReleaseVersion var1);

    @JsonIgnore
    default public PlatformRelease getRecommendedRelease() {
        Collection<PlatformRelease> releases = this.getReleases();
        if (releases.isEmpty()) {
            throw new RuntimeException("Stream " + this.getId() + " does not include any release");
        }
        return releases.iterator().next();
    }

    default public Mutable mutable() {
        return new PlatformStreamImpl.Builder(this);
    }

    public static Mutable builder() {
        return new PlatformStreamImpl.Builder();
    }

    public static interface Mutable
    extends PlatformStream,
    JsonBuilder<PlatformStream> {
        public Mutable setId(String var1);

        public Mutable setName(String var1);

        public Mutable setReleases(Collection<PlatformRelease> var1);

        public Mutable addRelease(PlatformRelease var1);

        public Mutable setMetadata(Map<String, Object> var1);

        public Mutable setMetadata(String var1, Object var2);

        public Mutable removeMetadata(String var1);

        @Override
        public PlatformStream build();
    }
}

