/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.deployment.compose;

import io.quarkus.devservices.deployment.compose.ComposeFile;
import io.quarkus.devservices.deployment.compose.ComposeServiceDefinition;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ComposeFiles {
    private final Map<String, ComposeServiceDefinition> serviceDefinitions = new HashMap<String, ComposeServiceDefinition>();
    private final String projectName;
    private final List<File> files;

    public ComposeFiles(List<File> composeFiles) {
        this.files = composeFiles;
        String name = null;
        for (File composeFile : composeFiles) {
            ComposeFile compose = new ComposeFile(composeFile);
            for (Map.Entry<String, ComposeServiceDefinition> service : compose.getServiceDefinitions().entrySet()) {
                if (this.serviceDefinitions.containsKey(service.getKey())) {
                    throw new IllegalArgumentException("Service name conflict: " + service.getKey());
                }
                this.serviceDefinitions.put(service.getKey(), service.getValue());
            }
            if (name != null) continue;
            name = compose.getProjectName();
        }
        this.projectName = name;
    }

    public Set<String> getAllServiceNames() {
        return this.serviceDefinitions.keySet();
    }

    public Map<String, ComposeServiceDefinition> getServiceDefinitions() {
        return this.serviceDefinitions;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public List<File> getFiles() {
        return this.files;
    }
}

